/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_TEXT_H___)
#define ___GRAPHC2D_TEXT_H___

#include "common.h"
#include "color.h"
#include "component.h"
#include "vector2.h"
#include <cstdarg>
#include <string>

#if defined(TARGET_IPHONE)
#import "platform/iOS/text_impl.h"
#elif defined(TARGET_WINDOWS)
#include "platform/windows/text_impl.h"
#endif

namespace Graph2D
{
#if !defined(TARGET_APPLE)
	typedef int UITextAlignment;
#endif

	class Text : public Component
	{
		DISALLOW_COPY_AND_ASSIGN(Text);

		typedef Component super;

	protected:
		void* instance;
		std::string text;
		Color textColor;
		bool dirty;

	protected:
		virtual ~Text();

	public:
		Text();
		Text(const size_t fontSize);

		virtual const char* getTypeName() const
		{
			return "Text";
		}

		void clear();
		bool empty() const
		{
			return text.empty();
		}

		void setFontName(const std::string& fontName);
		void setFontSize(const float fontSize);

		const Color& getTextColor() const;
		void setTextColor(const Color& color);
		void setTextColor(const float r, const float g, const float b, const float a)
		{
			setTextColor(Color(r, g, b, a));
		}

		TextAlignmentH getTextAlignmentH() const;
		void setTextAlignmentH(const TextAlignmentH textAlignment);

		TextAlignmentV getTextAlignmentV() const;
		void setTextAlignmentV(const TextAlignmentV textAlignment);

		const std::string& getString() const;
		void setString(const std::string& text);
		void setString(const char* text)
		{
			setString(std::string(text));
		}
		void format(const char* format, ...);
		void vformat(const char* format, va_list ap);
		void replace(const char* key, const char* word);

		void adjustSize();
		Vector2 getAdjustedSize();

		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);
		virtual void onUpdate(const UpdateInfomation& updateInfomation);
		virtual void onDraw(const DrawRect& drawRect);

		virtual bool compare(const Text& other) const;
	};
}

#endif
