/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_TEXT_WINDOW_H___)
#define ___GRAPHC2D_TEXT_WINDOW_H___

#include "window.h"

namespace Graph2D
{
	class Text;

	class TextWindow : public Window
	{
		DISALLOW_COPY_AND_ASSIGN(TextWindow);

		typedef Window super;

		float timer;
		float wait;
		Text* text;

	protected:
		~TextWindow();

	public:
		TextWindow();

		virtual const char* getTypeName() const
		{
			return "TextWindow";
		}

		void clear();
		bool empty() const;

		void setFontName(const std::string& fontName);
		void setFontSize(const float fontSize);

		const Color& getTextColor() const;
		void setTextColor(const Color& color);
		void setTextColor(const float r, const float g, const float b, const float a);

		TextAlignmentH getTextAlignmentH() const;
		void setTextAlignmentH(const TextAlignmentH textAlignment);

		TextAlignmentV getTextAlignmentV() const;
		void setTextAlignmentV(const TextAlignmentV textAlignment);

		const std::string& getString() const;
		void setString(const std::string& text);

		void format(const char* format, ...);
		void vformat(const char* format, va_list ap);

		void replace(const char* key, const char* word);

		float getAutoCloseTimer() const;
		void setAutoCloseTimer(const float wait);
		void disableAutoClose();

		bool finished() const;

		Text& getText();
		const Text& getText() const;

#if defined(DEBUG) || defined(_DEBUG) || defined(_DEBUG_) || !defined(NDEBUG)
		virtual void open();
		virtual void close();
#endif
		virtual void onUpdate(const UpdateInfomation& updateInfomation);
#if defined(DEBUG) || defined(_DEBUG) || defined(_DEBUG_) || !defined(NDEBUG)
		virtual void onDraw(const DrawRect& drawRect);
#endif
		virtual void onSizeChanged();
	};
}

#endif
