/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_TEXTURE_H___)
#define ___GRAPH2D_TEXTURE_H___

#include "base.h"
#include "vector2.h"
#include <string>
#include <mana_stream.h>

namespace Graph2D
{
	class Texture : public Base
	{
		DISALLOW_COPY_AND_ASSIGN(Texture);

		typedef Base super;

		static GLuint lastBindTextureName;

		void* instance;
		bool compressed;
		std::string filename;

	protected:
		~Texture();

	public:
		Texture();
		explicit Texture(const std::string& filename, const bool compressed);

		void serialize(mana_stream* stream) const;
		void deserialize(mana_stream* stream);

		bool load(const std::string& filename, const bool compressed);
		void unload();

		void bind();
		static void unbind();

		const std::string& getFileName() const;
		Vector2 getSize() const;
		Vector2 getTextureSize() const;
		Vector2 getMaxSize() const;
	};
}

#endif
