/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_WINDOW_H___)
#define ___GRAPH2D_WINDOW_H___

#include "container.h"

namespace Graph2D
{
	typedef enum WindowAnimationType
	{
		WINDOW_ANIMATION_TYPE_OPEN = 0,
		WINDOW_ANIMATION_TYPE_CLOSE,
		WINDOW_ANIMATION_TYPE_OPENED,
		WINDOW_ANIMATION_TYPE_CLOSED,
	}WindowAnimationType;

	class Window : public Container
	{
		DISALLOW_COPY_AND_ASSIGN(Window);

		typedef Container super;

	protected:
		WindowAnimationType animationType;		//!< アニメーション状態
		float animationWindowTime;				//!< アニメーション時間
		Color animationWindowColor;				//!< 色
		Vector2 animationWindowScale;			//!< スケール

	protected:
		virtual ~Window()
		{
		}

	public:
		Window();

		virtual const char* getTypeName() const
		{
			return "Window";
		}

		virtual void open();
		virtual void close();
		virtual bool closed() const;
		bool isAnimationStoped() const;

		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);
		virtual void onUpdateLayout();
		virtual void onUpdate(const UpdateInfomation& updateInfomation);
		virtual void onDraw(const DrawRect& drawRect);

		virtual bool touchesBegan(const Vector2& localPosition);
		virtual bool touchesMoved(const Vector2& localPosition);
		virtual bool touchesEnded(const Vector2& localPosition);
		virtual bool touchesCancelled(const Vector2& localPosition);

		virtual bool compare(const Window& window) const;

		static float getAnimationTime();
	};
}

#endif
