/*
 * stm32h7_hal.cpp
 *
 *  Created on: 27 мая 2019 г.
 *      Author: Lityagin Aleksandr
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#include "stm32h7xx.h"
#include "cslr.h"
#include "mcu_rcc.h"

void RCC_GetSystemClocksFreq(RCC_ClocksTypeDef* x){
    x->SYSCLK_Frequency = HAL_RCC_GetSysClockFreq();
    x->HCLK_Frequency   = HAL_RCC_GetHCLKFreq();
    x->PCLK1_Frequency  = HAL_RCC_GetPCLK1Freq();
    x->PCLK2_Frequency  = HAL_RCC_GetPCLK2Freq();

    static const unsigned D3CorePrescTable[]= {0,0,0,0,1,2,3,4};
    unsigned divid = (RCC->D1CFGR & RCC_D1CFGR_D1PPRE)>> POSITION_VAL(RCC_D1CFGR_D1PPRE_0);
    x->PCLK3_Frequency  = x->HCLK_Frequency >> D3CorePrescTable[divid];
    divid = (RCC->D3CFGR & RCC_D3CFGR_D3PPRE)>> POSITION_VAL(RCC_D3CFGR_D3PPRE_0);
    x->PCLK4_Frequency  = x->HCLK_Frequency >> D3CorePrescTable[divid];
}


