порт HAL для renesas RA2L chips with FSP
=============================================================
базой железа для чипов RA использую их [FSP библиотеку](https://github.com/renesas/fsp).

проект конфигурируется FSP Configurator'ом, и ресурсы чипа подключаются хедером `"bsp_api.h"`

Eclipse проектам надо явно указать пути к сорсам.

структура
=============================================================
- файлы `mcu_*.h` - связывают библиотеку ХАЛ с SPL. ХАЛ не должен включать
  хедеры железа непосредственно, а делает это через адаптерующие хедеры. 

  Эти хедеры должны адаптировать различные библиотеки железа к общему АПИ. За образец 
  в настоящее время взят SPL STM32.

- `cslr.h` -  дает удобные макросы манипуляции битовыми полями регистров.
  использует стилистику определения битовых масок CMSIS соответствующего порта.
  Сделана по мотивам CSL TexasInstruments

- `pinName-board.h` - предоставляет перечисление всех пинов корпуса чипа. 
    Тип корпуса определяется  в `<mcu-chip.h>` макросами вида `RA2L1xXX`

- `int-master-arch.h` - хедер для ядра contiki

драйвера ядер чипа
=============================================================

- `dev/r_sci_uart_buf.h` - буферированый УАРТ с поддержкой ДМА, надстройка поверх 
    драйвера FSP `r_sci_uart`

- `dev/r_iic_master.h` - i2c-мастер с раширеным контролем транзакции. может отсылать 
    данные i2c-устройству в несколько вызовов. Необходим для `r_i2c_masterx`

- `dev/r_i2c_masterx.h` - драйвер устройства на шине i2c, с внутренней регистровой/адресной адресацией.
    умеет писать устройству посылки с адресной частью. Чтение ведет через рестарт шины.

- `dev/r_sci_i2c.h` - драйвер устройства на шине i2c, на ядре SCI simple I2C. 
        Предоставляет возможность удержания шины через рестарт, и продолжение предыдущей транзакции.
        Реализует продвинутый контроль зависания шины по линии SDA, и отвисания её.

- `dev/rtimer_agt.h` - шедулер rtimer для contiki

- `dev/crc_core.h` - поддержка аппаратного счета crc16 ansi/ccitt.

- `dev/r_ssp_sci.h` - интерфейс ssp_hal для ядра SCI, поверх  драйвера FSP `r_spi_sci`

- `dev/r_ssp_spi.h` - интерфейс ssp_hal для ядра SPI, поверх  драйвера FSP `r_spi`

- `dev/r_ssp_i2cx.h` - интерфейс ssp_hal поверх драйвера i2c-masterx. отлажено с `r_sci_i2c`
`

