/*
 * mcu_wdt.h
 *
 *  Created on: 10/03/2022
 *      Author: alexrayne <alexraynepe196@gmail.com>
 * --------------------------------------------------------------------------------------------------------------------
 *  wdt API, compat to STM HAL
 */

#ifndef BSP_CPU_MCU_WDT_H_
#define BSP_CPU_MCU_WDT_H_

#include <mcu-chip.h>

typedef R_WDT_Type          WDG_TypeDef;
typedef WDG_TypeDef         WDT_t;



/* function used to enable wdt in debug mode */
static inline
void enable_wdt_count_in_debug_mode(void){
    /* As per hardware manual's DBGREG module, section 2.6.4.2:- Clear this bit to enable WDT Reset/NMI in debug mode */
    R_DEBUG->DBGSTOPCR_b.DBGSTOP_WDT = 0;
}


//void wdt_reset(hWDT_t* x)
//void wdt_init();
//void wdt_print();



#endif /* BSP_CPU_MCU_WDT_H_ */
