/*
    (C) 2017 Renesas Electronics Corporation.
     This software is released under the terms and conditions described in LICENSE_RENESAS.TXT included in the project.
*/
#if !defined (__PIN_NAMES_RA2_H__)
#define __PIN_NAMES_RA2_H__

/*!
 * RA2L1 Pin Names. These include pins that are not available on the product used.
 */


/*!
 * use pin coding scheme [pot:8bit][pin:8bit] - same as FSP bsp_io use
 */

enum {
   P0_X=0x000u,
   P1_X=0x100u,
   P2_X=0x200u,
   P3_X=0x300u,
   P4_X=0x400u,
   P5_X=0x500u,
   P6_X=0x600u,
   P7_X=0x700u,
   P8_X=0x800u,
}; // GPIOPorts;

#define __RA2PORT_CAT(a, b) a##b
#define RA2PORT_1PIN(port, pin) __RA2PORT_CAT(port, pin)=__RA2PORT_CAT(port, X)+pin
#define RA2PORT_2PIN(port, a, b) RA2PORT_1PIN(port, a) , RA2PORT_1PIN(port, b)
#define RA2PORT_3PIN(port, a, b, c) RA2PORT_2PIN(port, a, b) , RA2PORT_1PIN(port, c)
#define RA2PORT_4PIN(port, a, b, c, d) RA2PORT_2PIN(port, a, b) , RA2PORT_2PIN(port, c, d)
#define RA2PORT_6PIN(port, a, b, c, d, e, f) RA2PORT_4PIN(port, a,b,c,d) , RA2PORT_2PIN(port, e,f)
#define RA2PORT_8PIN(port, a, b, c, d, e, f, g, h) RA2PORT_4PIN(port, a,b,c,d) , RA2PORT_4PIN(port, e,f,g,h)
#define RA2PORT_ALLPIN(port) RA2PORT_8PIN(port, 0,1,2,3,4,5,6,7), RA2PORT_8PIN(port, 8,9,10,11,12,13,14,15)

#ifdef RA2L1xFP
// QFP 100pin ports
#define MCU_P0PINS  RA2PORT_8PIN(P0_, 0,1,2,3,4,5,6,7), RA2PORT_6PIN(P0_, 8,10,11,12,13,14), RA2PORT_1PIN(P0_, 15)
#define MCU_P1PINS  RA2PORT_ALLPIN(P1_)
#define MCU_P2PINS  RA2PORT_8PIN(P2_, 0,1,2,3,4,5,6,7), RA2PORT_4PIN(P2_, 8,12,13,14), RA2PORT_1PIN(P2_, 15)
#define MCU_P3PINS  RA2PORT_8PIN(P3_, 0,1,2,3,4,5,6,7)
#define MCU_P4PINS  RA2PORT_ALLPIN(P4_)
#define MCU_P5PINS  RA2PORT_6PIN(P5_, 0,1,2,3,4,5)
#define MCU_P6PINS  RA2PORT_6PIN(P6_, 0,1,2,3,8,9), RA2PORT_1PIN(P6_, 10)
#define MCU_P7PINS  RA2PORT_2PIN(P7_, 8,14)
#define MCU_P8PINS  RA2PORT_2PIN(P8_, 8,9)
#elif defined(RA2L1xFM)
// QFP 64pin ports
#define MCU_P0PINS  RA2PORT_8PIN(P0_, 0,1,2,3,12,13,14,15) , RA2PORT_1PIN(P0_, 4)
#define MCU_P1PINS  RA2PORT_8PIN(P1_, 0, 1,2,3,4,5,6,7), RA2PORT_4PIN(P1_, 8, 9,10,11), RA2PORT_2PIN(P1_, 12, 13)
#define MCU_P2PINS  RA2PORT_6PIN(P2_, 0, 1, 4,5,6,7), RA2PORT_1PIN(P2_,8), RA2PORT_4PIN(P4_, 12,13,14, 15)
#define MCU_P3PINS  RA2PORT_4PIN(P3_, 0, 1,2,3), RA2PORT_1PIN(P3_, 4)
#define MCU_P4PINS  RA2PORT_8PIN(P4_, 0,1,2,3,7,8,9,10)
#define MCU_P5PINS  RA2PORT_3PIN(P5_, 0, 1, 2)

#define MCU_PINS  MCU_P0PINS, \
                  MCU_P1PINS, \
                  MCU_P2PINS, \
                  MCU_P3PINS, \
                  MCU_P4PINS, \
                  MCU_P5PINS

#else
#define MCU_P0PINS  RA2PORT_ALLPIN(P0_)
#define MCU_P1PINS  RA2PORT_ALLPIN(P1_)
#define MCU_P2PINS  RA2PORT_ALLPIN(P2_)
#define MCU_P3PINS  RA2PORT_ALLPIN(P3_)
#define MCU_P4PINS  RA2PORT_ALLPIN(P4_)
#define MCU_P5PINS  RA2PORT_ALLPIN(P5_)
#define MCU_P6PINS  RA2PORT_ALLPIN(P6_)
#define MCU_P7PINS  RA2PORT_ALLPIN(P7_)
#define MCU_P8PINS  RA2PORT_ALLPIN(P8_)
#endif

#ifndef MCU_PINS
#define MCU_PINS  MCU_P0PINS, \
                  MCU_P1PINS, \
                  MCU_P2PINS, \
                  MCU_P3PINS, \
                  MCU_P4PINS, \
                  MCU_P5PINS, \
                  MCU_P6PINS, \
                  MCU_P7PINS, \
                  MCU_P8PINS
#endif

#endif //#if !defined (__PIN_NAMES_RL78_H__)
