/*
 * eeprom_m24m01.h
 *
 *  Created on: 15/10/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
 * ----------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * ------------------------------------------------------------------
     STM M24M01 1Mbit I2C eeprom on i2c_masterx SSP
 */

#ifndef BSP_DEV_FLASH_EEPROM_M24M01_H_
#define BSP_DEV_FLASH_EEPROM_M24M01_H_

#include "flash_i2c_hal.h"


//////////////////////////////////////////////////////////////////////////////

enum {
    M24M01_SLA      = 0xA0>>1,
    M24M01ID_SLA    = 0xB0>>1,

    M24M01_CS0      = 0,
    M24M01_CS1      = 1u<<1,
    M24M01_CS2      = 2u<<1,
    M24M01_CS3      = 3u<<1,

    M24M01_NOTHING  = 0,
    M24M01_NOCS     = 0,
};

enum {
    M24M01_BANK0    = 1,
    M24M01_BANK1    = 2,
    M24M01_BANK2    = 4,
    M24M01_BANK3    = 8,
};
typedef unsigned    M24M01BankSet;


struct I2CFLASH_M24M01{
    I2CFlash_GenDevice  dev;

    uint8_t             nodes[8];   //chips SLA
    struct FlashChipDescribe    bank_info;
};
typedef struct I2CFLASH_M24M01 I2CFLASH_M24M01;

/// @arg banks - перечень чипов участвующих в банке
DevResult m24m01_init(I2CFLASH_M24M01* this, M24M01BankSet banks);
void      m24m01_connect(I2CFLASH_M24M01* this, SSP_IOPort*    _port);

static inline
SSP_IODevice* m24m01_ssp(I2CFLASH_M24M01* this) { return  &this->dev.ssp; }


/// @return true - if addr ... + len places in one m24 chip bank
bool m24m01_in_single_bank(const FLASH_Device* this, flash_addr_t addr, unsigned len);


#define M24M01_PAGE_SIZE 256
#define M24M01_SEC_SIZE  M24M01_PAGE_SIZE
#define M24M01_SEC_PAGES 1
#define M24M01_SECTORS   512
#define M24M01_PAGES     (M24M01_SECTORS*M24M01_SEC_PAGES)
#define M24M01_SIZE      (M24M01_SECTORS*M24M01_SEC_SIZE)



#endif /* BSP_DEV_FLASH_EEPROM_M24M01_H_ */
