/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
*      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is for STM SPL compatibily wrapers
 */

#ifndef HAL_MDR32F9QX_MCU_GPIO_H_
#define HAL_MDR32F9QX_MCU_GPIO_H_

#include <stdint.h>
#include <project-conf.h>
#include <mcu-chip.h>

// #if defined(__CM4_REV) || (__CORTEX_M == 4)
#if defined(STM32F4)   //__STM32F4xx_HAL_CONF_H
#include <stm32f4xx_ll_gpio.h>
#elif defined(STM32L1)
#include <stm32l1xx_ll_gpio.h>
#else
#warning "uncknown STM32 HAL"
#endif

#include <c_compat.h>

#define GPIO_PORT_NO(port)  (((uint32_t)port-GPIOA_BASE)>>10)
//#define RCC_GPIO(port)  ( RST_CLK_PER_CLOCK_PCLK_EN_PORTA<<GPIO_PORT_NO(port) )

#ifdef __cplusplus
extern "C" {
#endif

#define GPIO_StructInit(...)    PORT_StructInit(__VA_ARGS__)
#define GPIO_Init(...)          PORT_Init(__VA_ARGS__)

#define GPIO_SetBits(...)       LL_GPIO_SetOutputPin(__VA_ARGS__)
#define GPIO_ResetBits(...)     LL_GPIO_ResetOutputPin(__VA_ARGS__)
#define GPIO_WriteBit(...)      LL_GPIO_WriteOutputPort(__VA_ARGS__)
#define GPIO_ReadInputData(...) LL_GPIO_ReadInputPort(__VA_ARGS__)
#define GPIO_TwistBits(...)     LL_GPIO_TogglePin(__VA_ARGS__)

INLINE
unsigned GPIO_Bits(GPIO_TypeDef* port, unsigned pins){
    return LL_GPIO_ReadOutputPort(port) & pins;
}



#ifndef GPIO_PIN_0
#define GPIO_PIN_0          LL_GPIO_PIN_0
#define GPIO_PIN_1          LL_GPIO_PIN_1
#define GPIO_PIN_2          LL_GPIO_PIN_2
#define GPIO_PIN_3          LL_GPIO_PIN_3
#define GPIO_PIN_4          LL_GPIO_PIN_4
#define GPIO_PIN_5          LL_GPIO_PIN_5
#define GPIO_PIN_6          LL_GPIO_PIN_6
#define GPIO_PIN_7          LL_GPIO_PIN_7
#define GPIO_PIN_8          LL_GPIO_PIN_8
#define GPIO_PIN_9          LL_GPIO_PIN_9
#define GPIO_PIN_10         LL_GPIO_PIN_10
#define GPIO_PIN_11         LL_GPIO_PIN_11
#define GPIO_PIN_12         LL_GPIO_PIN_12
#define GPIO_PIN_13         LL_GPIO_PIN_13
#define GPIO_PIN_14         LL_GPIO_PIN_14
#define GPIO_PIN_15         LL_GPIO_PIN_15
#define GPIO_PIN_ALL        LL_GPIO_PIN_ALL
#endif

#ifndef GPIO_SPEED_FREQ_LOW
#define GPIO_SPEED_FREQ_LOW          LL_GPIO_SPEED_FREQ_LOW
#define GPIO_SPEED_FREQ_MEDIUM       LL_GPIO_SPEED_FREQ_MEDIUM
#define GPIO_SPEED_FREQ_HIGH         LL_GPIO_SPEED_FREQ_HIGH
#define GPIO_SPEED_FREQ_VERY_HIGH    LL_GPIO_SPEED_FREQ_VERY_HIGH
#endif


// описатель стиля пина, для упрощенного объявления структуры инициализации пина PIN_INIT
enum PinStyle{
    psINV     = 1, //inverted
    psOD      = 2, //open drain
    psANALOG  = 0x10, //pull up
    psPU      = 0x20, //pull up
    psPullUp  = psPU,
    psPD      = 0x40, //pull dn
    psPullDn  = psPD,
    psNONE    = 0,
};

struct PIN_INIT_s{
    GPIO_TypeDef*   port;
    uint8_t         pin;
    uint8_t         style; // \sa PinStyle
};
typedef struct PIN_INIT_s PIN_INIT;
#define PININIT_DEF(p, n, _style) {\
        struct_field(port) p, struct_field(pin) n, struct_field(style) _style\
    }


#define PORT_FUNC_DECL_AF( afid ) PORT_FUNC_AF##afid = LL_GPIO_AF_##afid
enum PORT_FUNC_TypeDef{
      PORT_FUNC_DECL_AF(0)
    , PORT_FUNC_DECL_AF(1)
    , PORT_FUNC_DECL_AF(2)
    , PORT_FUNC_DECL_AF(3)
    , PORT_FUNC_DECL_AF(4)
    , PORT_FUNC_DECL_AF(5)
    , PORT_FUNC_DECL_AF(6)
    , PORT_FUNC_DECL_AF(7)
    , PORT_FUNC_DECL_AF(8)
    , PORT_FUNC_DECL_AF(9)
    , PORT_FUNC_DECL_AF(10)
    , PORT_FUNC_DECL_AF(11)
    , PORT_FUNC_DECL_AF(12)
    , PORT_FUNC_DECL_AF(13)
    , PORT_FUNC_DECL_AF(14)
    , PORT_FUNC_DECL_AF(15)
      // this mode uses for config to analog mode
    , PORT_FUNC_ANALOG,
    //, PORT_FUNC_PORT
    PORT_FUNC_MASK  = 0x1f,
};
typedef  enum PORT_FUNC_TypeDef   PORT_FUNC_TypeDef;


// описатель структуры инициализации группы пинов на альтернативную функцию
struct GPIOFUNC_INIT{
    GPIO_TypeDef*       port;
    uint16_t            pins;
    uint16_t            func;       //PORT_FUNC_TypeDef
};
typedef struct GPIOFUNC_INIT GPIOFUNC_INIT;
#define PINFUNC_DEF(p, n, f) {\
        struct_field(port) p, struct_field(pins) n, struct_field(func) f\
    }



#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
