/*
 * eeprom_m24m01.h
 *
 *  Created on: 15/10/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
  * ----------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * ------------------------------------------------------------------
     STM M24M01 1Mbit I2C eeprom on i2c_masterx SSP
 */

#ifndef BSP_DEV_HAL_FLASH_I2C_H_
#define BSP_DEV_HAL_FLASH_I2C_H_

#include "flash_hal.h"
#include "ssp_hal.h"

//////////////////////////////////////////////////////////////////////////////

struct I2CFlash_GenDevice;
typedef struct I2CFlash_GenDevice I2CFlash_GenDevice;

struct I2CFlash_GenDevice{
    FLASH_Device    flash;
    SSP_IODevice    ssp;
};

// установка занятости флеша делается после отправки соответствующих операций,
//      позволяет видет актуальный статус флеша еще до опроса его статуса.
static inline
void  flashi2c_force_busy(I2CFlash_GenDevice* this) {
    flash_force_busy(&this->flash);
};

//////////////////////////////////////////////////////////////////////////////

// EEPROM device have no erase functions - they leave it dummy.
DevResult flashi2c_init(I2CFlash_GenDevice* this);


DevResult  flashi2c_select(FLASH_Device* self, unsigned csid);
FlashState flashi2c_state(FLASH_Device* self);

PTResult  flashi2c_read_one(FLASH_Device* self, flash_addr_t addr, void* dst, unsigned len);
PTResult  flashi2c_read_pages(FLASH_Device* self, flash_addr_t addr, void* dst, unsigned len);
PTResult  flashi2c_write(FLASH_Device* self, flash_addr_t addr, const void* src, unsigned len);
PTResult  flashi2c_flush(FLASH_Device* self);


//////////////////////////////////////////////////////////////////////////////
/// низкоуровневые операции работы со страницами.
///  flashspi:read/write/erase работают через них.

PTResult flashi2c_ask_page(FLASH_Device* self, void* dst, flash_page_t page, unsigned len);
PTResult flashi2c_post_page(FLASH_Device* self, void* src, flash_page_t page, unsigned len);

DevResult flashi2c_read_page(FLASH_Device* self, void* dst, flash_page_t page, unsigned len);
DevResult flashi2c_write_page(FLASH_Device* self, void* src, flash_page_t page, unsigned len);



#endif /* BSP_DEV_HAL_FLASH_I2C_H_ */
