#ifndef CLI_KEYS_HPP
#define CLI_KEYS_HPP
/*
 * ru utf8
 *
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
   -------------------------------------------------------------------------
   this is a part of MCU HAL cli library
*/

/*
 * объявляю тут коды символов и клавиш терминалов shell
*/



namespace cli {

    typedef int KeyCode;

    enum KeyModifier {
        kmPos               = 8, //< bit position in symbol code
        kmNo                = 0,
        //< VT100 SCI seq code
        kmSCI               = 1 << kmPos,

        kmSHIFT             = 0x20 << kmPos,
        kmCTRL              = 0x40 << kmPos,
        kmALT               = 0x80 << kmPos,

        // Do not extend the mask to include 0x01000000
        kmMsk               = kmSHIFT | kmCTRL | kmALT,
    };

    enum VTKeys{
        keyUP   =   'A' | kmSCI ,
        keyDN   =   'B' | kmSCI  ,
        keyL    =   'C' | kmSCI  ,
        keyR    =   'D' | kmSCI  ,
        keyHOME =   'H' | kmSCI  ,
        keyEND  =   'F' | kmSCI  ,

        modeINS =   'h' | kmSCI  ,
        modeOVR =   'l' | kmSCI  ,

        keyDEL  =   127  ,
        keyCR   =   '\r' ,
        keyLF   =   '\n' ,
        keyBR   =   '\b' ,
        keyBEL  =   8 ,
        keyESC  =   0x1b, 

    };

}; //namespace cli


#include "lib/EnumClass.h"

enableEnumClassBitmask(cli::KeyModifier);


#endif // CLI_KEYS_HPP
