/*
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
*/
#include <project-conf.h>
#include "system_heap.h"

#define HEAP_STYLE_NODEALLOC 0
#define HEAP_STYLE_NORMAL    1

//#define HEAP_STYLE HEAP_STYLE_NORMAL
#define HEAP_STYLE HEAP_STYLE_NODEALLOC

#if HEAP_STYLE == HEAP_STYLE_NODEALLOC
static char memory1[PRE_ALLOC_MEMORY_SIZE];
static int size1 = sizeof(memory1);
static char *m = memory1;

void initMe(){
    size1 = sizeof(memory1);
    m = memory1;
};

size_t availMe(void){
    return size1;
}

void *allocMe(size_t s){
#ifdef __unix__
    std::cerr << "+++Alloc size: " << s << std::endl;
    std::cerr << "+++Current size: " << size1 << std::endl;
#endif

#ifdef HWDEBUG
    FPrintUsrLog(putcharx_hw, "+++Alloc size: %d\r\n", s);
    FPrintUsrLog(putcharx_hw, "+++Current size: %d\r\n", size1);
#endif

    size1 -= s;

#ifndef __unix__
//    assert_param(size1 > 0);
    // TODO

    if (!(size1 > 0)){
                    #ifdef HWDEBUG
                        FPrintUsrLog(putcharx_hw, "!!!Sizeof memory: %d\r\n", size1);
					#endif
        while(1){
					;
				}
			}
#else
    assert(size1 > 0);
#endif

#ifdef __unix__
    std::cerr << "+++After size: " << size1 << std::endl;
    std::cerr << "+++Memory at: " << (void *)m << std::endl;
#endif

#ifdef HWDEBUG
    FPrintUsrLog(putcharx_hw, "+++After size: %d\r\n", size1);
    FPrintUsrLog(putcharx_hw, "+++Memory at: 0x%X\r\n", (void *)m);
#endif

    void *p = (void*) m;
#ifdef __unix__
    std::cerr << "+++Allocated at: " << (void *)p << std::endl;
#endif

#ifdef HWDEBUG
    FPrintUsrLog(putcharx_hw, "+++Allocated at: 0x%X\r\n", (void *)p);
#endif

    m = m + s;

#ifdef __unix__
    std::cerr << "+++Memory at: " << (void *)m << std::endl;
#endif

#ifdef HWDEBUG
    FPrintUsrLog(putcharx_hw, "+++Memory at: 0x%X\r\n", (void *)m);
#endif

    return p;
}

void deallocMe(void *p, size_t s){
#ifdef __unix__
    std::cerr << "---Dealloc Memory at: " << (void *)p << std::endl;
    std::cerr << "---Dealloc size: " << s << std::endl;
#endif

#ifdef HWDEBUG
    FPrintUsrLog(putcharx_hw, "---Dealloc Memory at: 0x%X\r\n", (void *)p);
    FPrintUsrLog(putcharx_hw, "---Dealloc size:  %d\r\n", s);
#endif
}

#else //#if HEAP_STYLE == HEAP_STYLE_NODEALLOC

#include "intfaces/mem.h"

typedef long long mem_aligned_block;
static mem_aligned_block syspool_heap[PRE_ALLOC_MEMORY_SIZE/ sizeof(mem_aligned_block)];
mem_pool_t syspool = {0,0,0};

void initMe(void){
    if (syspool.free_list == NULL){
        syspool.lock = NULL;
        mem_init(&syspool, (size_t)syspool_heap, ((size_t)syspool_heap)+sizeof(syspool_heap) );
    }
};

size_t availMe(void){
    return mem_available(&syspool);
}

void *allocMe(size_t s){
    return mem_alloc(&syspool, s);
}

void deallocMe(void *p, size_t s){
    mem_free(p);
}


#endif // #else if HEAP_STYLE == HEAP_STYLE_NODEALLOC

