/*
 * OsTime.h
 *
 *  Created on: 1 ����. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
   -------------------------------------------------------------------------
 *      here wrapers for OS clock services
 */

#ifndef OSTIME_H_
#define OSTIME_H_


#include <stdint.h>
#include <stdbool.h>

#include "compiler-port.h"
#include <FreeRTOS.h>
#include <queue.h>
#include <task.h>

#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */




/// @brief <time.h>:tm fields def
enum {
    TM_YEAR0    = 1900u,
    TM_MON0     = 0,
    TM_MDAY0    = 1u,
    TM_WDAY0    = 0,
};




typedef TickType_t os_time_t;
struct os_timeout_s {
    TimeOut_t   time;
    TickType_t  least;
    TickType_t  timeout;
};
typedef struct os_timeout_s os_timeout_t;

INLINE
void ostimeout_init(os_timeout_t* timer, os_time_t timeout){
    vTaskSetTimeOutState(&timer->time);
    timer->timeout  = timeout;
    timer->least    = timer->timeout;
}

INLINE
bool ostimeout_expired(os_timeout_t* timer){
    return (xTaskCheckForTimeOut(&timer->time, &timer->least) == pdTRUE);
}

INLINE
bool ostimeout_least(os_timeout_t* timer){
    return timer->least;
}

INLINE
os_time_t clock_now(){
    return xTaskGetTickCount();
}

INLINE
os_time_t clock_now_isr(){
    return xTaskGetTickCountFromISR();
}



#include <timers.h>
typedef TimerHandle_t   os_clock_t;

INLINE
os_clock_t osclock_init(const char* name
                , os_time_t timeout
                , TimerCallbackFunction_t cb)
{
    return xTimerCreate(name, timeout, pdTRUE, (void*)name, cb);
}

INLINE
bool osclock_start(os_clock_t clock, unsigned to = portMAX_DELAY){
    return xTimerStart(clock, to) == pdTRUE;
}

INLINE
bool osclock_stop(os_clock_t clock, unsigned to = portMAX_DELAY){
    return xTimerStop(clock, to) == pdTRUE;
}


#ifdef __cplusplus
 }
#endif /* __cplusplus */

#endif /* OSTIME_H_ */
