#ifndef LINUX_SOCKIO_DEVICE_HPP_
#define LINUX_SOCKIO_DEVICE_HPP_
/*
 * sockio_device.hpp
 *
 *  Created on: 13 янв. 2020 г.
 *      Author: alexrayne
 */

#include "serial/stdio_hal.hpp"



class SockIODevice : public StdIO_Device
                    , public HAL_INBlock_Device
{
public:
    typedef int sockid;
    SockIODevice( sockid s = -1 );
    virtual ~SockIODevice();

    void init(sockid in);
    void close();
    sockid io() const {return sock;}

    virtual int get_char();
    virtual int get_wait(unsigned to = 0);

public: //HAL_INBlock_Device
    // блокирующий прием
    //*  \return - длинна полученного участка
    virtual int getData ( void* dst, unsigned len);
    //*  ожидание amount доступных символов
    virtual int get_waitfor(unsigned amount, unsigned to = 0);

public:     //StdOUT_Device
    //* блокирующая печать
    virtual int putChar(int ch);
    //*  неблокирующая печать
    virtual int postData ( const void* str, unsigned len);

public:     //HAL_OUTBlock_Device
    //* блокирующая печать
    virtual int puts( const char* str);
    //*  \return - длинна отправленного участка
    virtual int putData ( const void* str, unsigned len);

    //*  ожидание доступности печати
    //*  \return - количество байт возможных для неблокирующей печати
    virtual int put_wait(unsigned to = 0);
    //*  почти тоже put_wait, ждет полного опустошения
    virtual int put_flush(unsigned to = 0);
    //*  очищает буфер, прерывая текущую отправку
    virtual int put_drop();

    //* монополизация вывода (puts, putData предпочтительно использую ее )
    //* \arg onoff - захват/освобождение
    //* \return    - состояние захвачн ли вывод
    virtual bool put_access(bool onoff, unsigned to = toInfinite){
        (void)onoff; (void)to;
        return true;
    }

protected:
    sockid sock;

    int in_avail();
};



#endif /* LINUX_SOCKIO_DEVICE_HPP_ */
