/*
 * MessageDialogUI.java
 *
 * Created on 2007/08/14, 14:31
 */

package org.jent.checksmtp;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFrame;

/**
 *
 * @author  tkyn
 */
public class MessageDialogUI extends javax.swing.JFrame {
  static final int ERROR_MODE = 0;
  static final int WARNING_MODE = 1;
  static final int INFORMATION_MODE = 2;
  
  static final String MSG_DETAIL_OPEN = java.util.ResourceBundle
          .getBundle("org/jent/checksmtp/Bundle")
          .getString("MessageDialogUI.jButtonDetail.text.open");
  static final String MSG_DETAIL_CLOSE = java.util.ResourceBundle
          .getBundle("org/jent/checksmtp/Bundle")
          .getString("MessageDialogUI.jButtonDetail.text");
  
  static private boolean detailOpen = true;
  
  public boolean setDetailOpen(boolean flg) {
    boolean old = detailOpen;
    detailOpen = flg;
    return old;
  }
  
  /* Not use yet.
  public String setMessage(String newMessage) {
    String oldMessage = jTextAreaMessage.getText();
    jTextAreaMessage.setText(newMessage);
    return oldMessage;
  }
   */
  
  /** Creates new form MessageDialogUI */
  public MessageDialogUI(String message, Throwable ex, int mode) {
    super(); //paranoia statement.
    
    initComponents();
    
    //move to Forcus
    //Forcus change loop on JRE1.4 in Windows.    jButtonOK.requestFocusInWindow();
    //getRootPane().setDefaultButton(jButtonOK);
    
    jTextAreaMessage.setText(message); //NEEDCARE null string.
    if ( ex == null ) {
      jButtonDetail.setEnabled(false);
      jButtonDetail.setText(MSG_DETAIL_OPEN);
      jScrollPaneStack.setVisible(false);
      pack();
    } else {
      StringWriter stackTraceMessageWriter = new StringWriter();
      ex.printStackTrace(new PrintWriter(stackTraceMessageWriter));
      stackTraceMessageWriter.flush();
      jTextAreaStack.setText(stackTraceMessageWriter.toString());
      
      if (!detailOpen) {
        jButtonDetail.setText(MSG_DETAIL_OPEN);
        jScrollPaneStack.setVisible(false);
        pack();
      }
    }
    switch (mode) {
      case ERROR_MODE:
        setTitle(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle")
        .getString("MessageDialogUI.title.Error_mdc"));
        break;
      case WARNING_MODE:
        setTitle(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle")
        .getString("MessageDialogUI.title.Warning_mdc"));
        break;
      case INFORMATION_MODE:
        setTitle(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle")
        .getString("MessageDialogUI.title.Information_mdc"));
        break;
        //Default is "Message - mdc"
    }
    
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize =  getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    this.setBounds(
            (screenSize.width - frameSize.width) / 2,
            (screenSize.height - frameSize.height) / 2,
            frameSize.width, frameSize.height );
    
    setVisible(true);
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc=" Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    jPanel1 = new javax.swing.JPanel();
    jScrollPane1 = new javax.swing.JScrollPane();
    jTextAreaMessage = new javax.swing.JTextArea();
    jButtonOK = new javax.swing.JButton();
    jButtonDetail = new javax.swing.JButton();
    jScrollPaneStack = new javax.swing.JScrollPane();
    jTextAreaStack = new javax.swing.JTextArea();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle"); // NOI18N
    setTitle(bundle.getString("MessageDialogUI.title")); // NOI18N
    jTextAreaMessage.setColumns(20);
    jTextAreaMessage.setEditable(false);
    jTextAreaMessage.setLineWrap(true);
    jTextAreaMessage.setRows(3);
    jTextAreaMessage.setText(bundle.getString("MessageDialogUI.jTextAreaMessage.text")); // NOI18N
    jTextAreaMessage.setFocusable(false);
    jTextAreaMessage.setRequestFocusEnabled(false);
    jScrollPane1.setViewportView(jTextAreaMessage);

    jButtonOK.setText(bundle.getString("MessageDialogUI.jButtonOK.text")); // NOI18N
    jButtonOK.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonOKActionPerformed(evt);
      }
    });

    jButtonDetail.setText(bundle.getString("MessageDialogUI.jButtonDetail.text")); // NOI18N
    jButtonDetail.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButtonDetailActionPerformed(evt);
      }
    });

    jTextAreaStack.setColumns(20);
    jTextAreaStack.setEditable(false);
    jTextAreaStack.setRows(5);
    jTextAreaStack.setText(bundle.getString("MessageDialogUI.jTextAreaStack.text")); // NOI18N
    jScrollPaneStack.setViewportView(jTextAreaStack);

    org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
    jPanel1.setLayout(jPanel1Layout);
    jPanel1Layout.setHorizontalGroup(
      jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
        .addContainerGap()
        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
          .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPaneStack, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 398, Short.MAX_VALUE)
          .add(jPanel1Layout.createSequentialGroup()
            .add(jButtonDetail)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 238, Short.MAX_VALUE)
            .add(jButtonOK))
          .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 398, Short.MAX_VALUE))
        .addContainerGap())
    );
    jPanel1Layout.setVerticalGroup(
      jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanel1Layout.createSequentialGroup()
        .addContainerGap()
        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(jButtonOK)
          .add(jButtonDetail))
        .add(18, 18, 18)
        .add(jScrollPaneStack, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 176, Short.MAX_VALUE)
        .addContainerGap())
    );

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
    );
    pack();
  }// </editor-fold>//GEN-END:initComponents
  
  private void jButtonDetailActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetailActionPerformed
    if( detailOpen ) {
      jScrollPaneStack.setVisible(false);
      jButtonDetail.setText(MSG_DETAIL_OPEN);
      detailOpen = false;
    } else {
      jScrollPaneStack.setVisible(true);
      jButtonDetail.setText(MSG_DETAIL_CLOSE);
      detailOpen = true;
    }
    pack();
  }//GEN-LAST:event_jButtonDetailActionPerformed
  
  private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
    dispose();
  }//GEN-LAST:event_jButtonOKActionPerformed
  
  /**
   * @param args the command line arguments
   *
   * public static void main(String args[]) {
   * java.awt.EventQueue.invokeLater(new Runnable() {
   * public void run() {
   * new MessageDialogUI().setVisible(true);
   * }
   * });
   * }
   */
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton jButtonDetail;
  private javax.swing.JButton jButtonOK;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JScrollPane jScrollPaneStack;
  private javax.swing.JTextArea jTextAreaMessage;
  private javax.swing.JTextArea jTextAreaStack;
  // End of variables declaration//GEN-END:variables
  
}
