package org.jent.checksmtp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;


/**
 * Socket data proxy
 */
public class SocketProxy implements Runnable {
    InputStream is;
    OutputStream os;
    int mode = 0;

    public SocketProxy(InputStream is, OutputStream os, int mode) {
        this.is = is;
        this.os = os;
        this.mode = mode;
    }

    public void run() {
        System.err.println("Start SocketProxy mode=" + mode + ":" + this);

        int ch;

        try {
            while ((ch = is.read()) > 0) {
                os.write(ch);
                System.out.write(ch);
            }
        } catch (IOException e) {
            System.err.println("Exception occured in SocketProxy mode=" + mode);
            e.printStackTrace();
        }

        System.err.println("End  SocketProxy mode=" + mode + ":" + this);
    }
}
