$LOAD_PATH.push("#{File.dirname(__FILE__)}/../_lib")
#${chef-repo}/_lib/grid.rb
require 'grid'

name 'pleiades-node'
description 'Pleiades cluster node'

run_list(
  'role[hadoop-pleiades-with-security]',
  'role[hbase-pleiades-with-security]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

cluster = Grid::CLUSTERS[:pleiades]

default_attributes(
  'hadoop' => {
    'version' => '1.0.4',
    'metrics2' => {
      # multi-cast
      'namenode.sink.ganglia.servers'    => "#{cluster[:namenodes][:mcast_addr]}:8649",
      'datanode.sink.ganglia.servers'    => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'jobtracker.sink.ganglia.servers'  => "#{cluster[:jobtrackers][:mcast_addr]}:8649",
      'tasktracker.sink.ganglia.servers' => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'maptask.sink.ganglia.servers'     => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'reducetask.sink.ganglia.servers'  => "#{cluster[:datanodes][:mcast_addr]}:8649"
    }
  },
  'hbase' => {
    'version' => '0.94.7'
  }
)

#override_attributes "apache2" => { "max_children" => "50" }
