hdp Cookbook
============

This cookbook provides YUM utility recipes for HDP distribution.

Requirements
------------

#### cookbooks
- yum_utils

#### packages
none.

Attributes
----------

#### hdp::default
|Key|Type|Description (with examples)|Default|
|:--|:--|:--|:--|
|`['hdp']['version']`|String||`'1.3.1'`|
|`['hdp']['archive_url']`|String||`'http://public-repo-1.hortonworks.com'`|
|`['hdp']['yum_repo']['update']`|String||`false`|
|`['hdp']['yum_repo']['only_for_mirroring']`|String||`false`|
|`['hdp']['yum_repo']['mirroring']['platform']`|String|`'centos'`, `'rhel'`, `'suse'`|`'centos'`|
|`['hdp']['yum_repo']['mirroring']['platform_version']`|String||`'6'`|
|`['hdp']['yum_repo']['mirroring']['arch']`|String|`'x86_64'` (`'i386'` in the future)|`'x86_64'`|
|`['hdp']['yum_mirror']['user']`|String|mirroring user|`'yum-mirror'`|
|`['hdp']['yum_mirror']['cron_period']`|String|cron period expression|`'#0 3   * * *'` (inactive)|
|`['hdp']['yum_mirror']['base_path']`|String|base directory path|`'/var/spool/hdp-mirror'`|
|`['hdp']['yum_mirror']['yum_conf']`|String|YUM configuration file path|Debian: `'/etc/yum/yum.conf'`, RHEL: `'/etc/yum.conf'`|
|`['hdp']['yum_mirror']['repos_dir']`|String|repository configuration directory path|Debian: `'/etc/yum/repos.d'`, RHEL: `'/etc/yum.repos.d'`|
|`['hdp']['yum_mirror']['repo_ids']`|Array|mirroring repository ids|`[]` (empty)|
|`['hdp']['yum_mirror']['url_alias_with_authority_part']`|Boolean|use url alias with authority part|`true`|

Usage
-----
#### hdp::default
- do nothing.

#### hdp::yum_mirror
- set up mirroring configurations for HDP repository.

#### hdp::yum_repo
- set up YUM repository configurations of HDP.

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2013-2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
