#
# Cookbook Name:: samba-grid
# Recipe:: smbldap-tools
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

::Chef::Recipe.send(:include, ChefUtils::Helper)

chef_gem_package('chef-vault')

%w(
  smbldap-tools
).each {|pkg|
  resources(package: pkg) rescue package pkg do
    action :install
  end
}

template '/etc/smbldap-tools/smbldap.conf' do
  source  'etc/smbldap-tools/smbldap.conf'
  owner 'root'
  group 'root'
  mode '0644'
end

bind_conf = node['samba-grid']['smbldap-tools']['smbldap_bind.conf']
pws = {
  'slave' => 'secret',
  'master' => 'secret',
}

require 'chef-vault'
pws.each_key {|role|
  item_conf = bind_conf["#{role}Pw_vault_item"]
  next if item_conf.empty?

  secret = ChefVault::Item.load(item_conf['vault'], item_conf['name'])
  if item_conf.key?('env_context') && item_conf['env_context'] == true
    secret = secret[node.chef_environment]
  end
  if !item_conf['key'].nil? && !item_conf['key'].empty?
    item_conf['key'].split('/').each {|elm|
      secret = secret[elm]
    }
  end
  pws[role] = secret
}

template '/etc/smbldap-tools/smbldap_bind.conf' do
  source  'etc/smbldap-tools/smbldap_bind.conf'
  owner 'root'
  group 'root'
  mode '0600'
  variables(
    pws: pws
  )
  sensitive true
end
