gitlab-grid Cookbook
=====================

This cookbook sets up a GitLab server.

## Contents

- [Contents](#contents)
- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [gitlab-grid::default](#gitlab-griddefault)
        - [gitlab-grid::server](#gitlab-gridserver)
        - [gitlab-grid::docker-compose (NOT supported yet)](#gitlab-griddocker-compose-not-supported-yet)
    - [Role Examples](#role-examples)
    - [SSL server keys and certificates management by ssl_cert cookbook](#ssl-server-keys-and-certificates-management-by-ssl_cert-cookbook)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- none.

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['gitlab-grid']['with_ssl_cert_cookbook']`|Boolean|If this attribute is true, `node['gitlab-grid']['gitlab.rb']` are are overridden by the following `common_name` attributes.|`false`|
|`['gitlab-grid']['ssl_cert']['common_name']`|String|GitLab server common name for TLS|`node['fqdn']`|
|`['gitlab-grid']['gitlab.rb']`|Hash|`gitlab.rb` configurations.|See `attributes/default.rb`|
|`['gitlab-grid']['gitlab.rb_extra_config_str']`|String|`gitlab.rb` exstra configuration string (source code in Ruby).|`nil`|

## Usage

### Recipes

#### gitlab-grid::default

This recipe does nothing.

#### gitlab-grid::server

This recipe sets up a GitLab server.

#### gitlab-grid::docker-compose (NOT supported yet)

This recipe generates a docker-compose.yml for the GitLab server.

### Role Examples

- `roles/gitlab.rb`

```ruby
name 'gitlab'
description 'GitLab'

run_list(
  'recipe[gitlab-grid::server]',
)

#env_run_lists()

#default_attributes()

gitlab_cn = 'gitlab.io.example.com'

override_attributes(
  'gitlab-grid' => {
    'gitlab.rb' => {
      'external_url' => "http://#{gitlab_cn}",
      'gitlab_rails' => {
        'time_zone' => 'Asia/Tokyo',
      },
    },
  },
)
```

- `roles/gitlab-with-ssl-cert.rb`

```ruby
name 'gitlab-with-ssl-cert'
description 'GitLab setup with ssl_cert cookbook'

run_list(
  'recipe[ssl_cert::server_key_pairs]',
  'recipe[gitlab-grid::server]',
)

#env_run_lists()

#default_attributes()

gitlab_cn = 'gitlab.io.example.com'

override_attributes(
  'ssl_cert' => {
    'common_names' => [
      gitlab_cn,
    ],
  },
  'gitlab-grid' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => gitlab_cn,
    },
    'gitlab.rb' => {
      'external_url' => "http://#{gitlab_cn}",
      'gitlab_rails' => {
        'time_zone' => 'Asia/Tokyo',
      },
      'nginx' => {
        'redirect_http_to_https' => true,
      },
    },
  },
)
```

### SSL server keys and certificates management by ssl_cert cookbook

- create vault items.

```text
$ ruby -rjson -e 'puts JSON.generate({"private" => File.read("gitlab_io_example_com.prod.key")})' \
> > ~/tmp/gitlab_io_example_com.prod.key.json

$ knife vault create ssl_server_keys gitlab.io.example.com.prod \
> --json ~/tmp/gitlab_io_example_com.prod.key.json

$ ruby -rjson -e 'puts JSON.generate({"public" => File.read("gitlab_io_example_com.prod.crt")})' \
> > ~/tmp/gitlab_io_example_com.prod.crt.json

$ knife vault create ssl_server_certs gitlab.io.example.com.prod \
> --json ~/tmp/gitlab_io_example_com.prod.crt.json
```

- grant reference permission to the gitlab host

```text
$ knife vault update ssl_server_keys  gitlab.io.example.com.prod -S 'name:gitlab*.io.example.com'
$ knife vault update ssl_server_certs gitlab.io.example.com.prod -S 'name:gitlab*.io.example.com'
```

- modify run_list and attributes

```ruby
run_list(
  'recipe[ssl_cert::server_key_pairs]',
  'recipe[gitlab-grid::server]',
  #'recipe[gitlab-grid::docker-compose]',
)

override_attributes(
  'ssl_cert' => {
    'common_names' => [
      'gitlab.io.example.com',
    ],
  },
  'gitlab-grid' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => 'gitlab.io.example.com',
    },
    # ...
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
