name 'concourse'
description 'Concourse'

run_list(
  #'recipe[ssl_cert::server_key_pairs]',  # for https
  'role[docker]',
  #'recipe[concourse-ci::fly]',
)

#env_run_lists()

#default_attributes()

image = 'concourse/concourse'  # of 'concourse/concourse:2.6.0',...
port = '8080'  # '8443' (for https)
concourse_cn = 'concourse.io.example.com'

override_attributes(
  # for https
  'ssl_cert' => {
    'common_names' => [
      concourse_cn,
    ],
  },
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
      'storage-driver_on_centos' => 'overlay',
      'storage-driver_on_ubuntu' => 'aufs',  # default: aufs
    },
    'compose' => {
      'skip_setup' => false,
    },
  },
  'concourse-ci' => {
    'with_ssl_cert_cookbook' => false,  # or true (for https)
    'ssl_cert' => {
      'common_name' => concourse_cn,
    },
    'docker-compose' => {
      'config' => {
        # Version 1 docker-compose format
        'concourse-web' => {
          'image' => image,
          #'ports' => [
          #  #"#{port}:8080",  # If you sepecify no value, Chef will sets '8080:8080'.
          #  #"#{port}:8443",  # for https
          #],
          'environment' => {
            # If you sepecify no value, Chef will sets "http://#{node['ipaddress']}:8080".
            #'CONCOURSE_EXTERNAL_URL' => "http://192.168.1.3:#{port}",  # or "https://192.168.1.3:#{port}"
            #'CONCOURSE_TLS_BIND_PORT' => '8443',  # activate HTTPS
            # These environments will be set by the concourse-ci::docker-compose recipe automatically.
            #'CONCOURSE_TLS_CERT' => '/root/server.crt',
            #'CONCOURSE_TLS_KEY' => '/root/server.key',
          },
          #'volumes' => [
          #  # These volumes will be set by the concourse-ci::docker-compose recipe automatically.
          #  #"#{server_cert_path(node['concourse-ci']['ssl_cert']['common_name'])}:/root/server.crt:ro",
          #  #"#{server_key_path(node['concourse-ci']['ssl_cert']['common_name'])}:/root/server.key:ro",
          #],
        },
        'concourse-worker' => {
          'image' => image,
        },
      },
    },
  },
)
