#
# Cookbook Name:: ssh_utils
# Attributes:: default
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['ssh_utils']['with_ssl_cert_cookbook'] = false
# If node['ssh_utils']['with_ssl_cert_cookbook'] is true,
# node['ssh_utils']['sshd_config']['extra_props']['TrustedUserCAKeys']
# is overridden by the following 'ca_pubkey_name' attributes.
default['ssh_utils']['ssl_cert']['ca_pubkey_name'] = nil
# If node['ssh_utils']['with_ssl_cert_cookbook'] is true,
# node['ssh_utils']['sshd_config']['extra_props']['RevokedKeys']
# is overridden by the following 'ssh_ca_krl_name' attributes.
default['ssh_utils']['ssl_cert']['ssh_ca_krl_name'] = nil  # e.g. 'grid_ssh_ca'

# server
default['ssh_utils']['sshd_config'] = {
  'extra_props' => {
    # e.g.
    #'Banner' => '/etc/issue.net',
    #'TrustedUserCAKeys' => '/path/to/ssh_ca_public_keys.pub',
    #'RevokedKeys' => '/path/to/ssh_ca.krl',
  },
}

