name 'hbase-pleiades'
description 'Pleiades HBase cluster node'

run_list(
  'role[node_commons]',
  # LDAP (option)
  #'role[nameservice-client-grid]',
  'role[hbase]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

hbase_attributes = {
  # hbase-site.xml
  'this.cluster.name' => 'pleiades', 
  'this.domain' => 'grid.example.com',
  'this.namenode.fqdn' => '${this.cluster.name}-nn.${this.domain}',
  'hbase.zookeeper.quorum' \
    => 'zk00.grid.example.com,zk01.grid.example.com,zk02.grid.example.com'
}

default_attributes(
  'hbase' => hbase_attributes
)

#override_attributes "apache2" => { "max_children" => "50" }
