/*
 * Copyright (C) 2022 YOSHIDA Shintarou
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer;

import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import javax.swing.JComponent;
import javax.swing.JList;
import jp.synthtarou.midimixer.libs.console.MXConsoleModel;
import jp.synthtarou.midimixer.libs.midi.MXMessage;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMidiLogger extends MXReceiver {
    MXConsoleModel _console;
    String _name;
    
    public MXMidiLogger(String name) {
        _name = name;
        _console = new MXConsoleModel(500);
    }
    
    public void attach(JList list) {
        _console.bind(list);
        list.setModel(_console);                    
    }

    @Override
    public String getReceiverName() {
        return _name;
    }

    @Override
    public JComponent getReceiverView() {
        return null;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (usingThis()) { 
            StringBuffer str = new StringBuffer();
            str.append(_name);
            str.append(":");
            str.append(message.toString());
            _console.addConsoleMessage(str.toString());
        }

        if (getNextReceiver() != null) {
            sendToNext(message);
        }
    }
}
