/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.Comparator;
import java.util.TreeSet;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMessageCapture {
    public static final MXMessageCapture capture = new MXMessageCapture(50);

    public static MXMessageCapture getInstance() {
        return capture;
    }
    
    MXMessage[] _captureData;
    int _capturePos;
            
    public MXMessageCapture(int size) {
        _captureData = new MXMessage[size];
        _capturePos = 0;
    }
    
    public void clear() {
        for(int i = 0; i < _captureData.length; ++ i) {
            _captureData[i] = null;
        }
    }
    
    public synchronized void process(MXMessage message) {
        _captureData[_capturePos ++] = message;
        if (_capturePos >= _captureData.length) {
            _capturePos = 0;
        }
    }
    
    public synchronized TreeSet<MXMessage> getCapture() {
        TreeSet<MXMessage> unique = new TreeSet<MXMessage>(new MXMessageComparator());
        for (int i = 0; i < _captureData.length; ++ i) {
            MXMessage message = _captureData[i];
            if (message != null) {
                unique.add(message);
            }
        }
        return unique;
    }
    
    public static class MXMessageComparator implements Comparator {
        public int compare(Object o1, Object o2) {
            MXMessage m1 = (MXMessage)o1;
            MXMessage m2 = (MXMessage)o2;
            if (m1._port < m2._port) {
                return  -1;
            }
            if (m1._port > m2._port) {
                return 1;
            }
            if (m1._extype < m2._extype) {
                return  -1;
            }
            if (m1._extype > m2._extype) {
                return 1;
            }

            byte[] data1 = m1.getDataBytes();
            byte[] data2 = m2.getDataBytes();

            int length = Math.max(data1.length, data2.length);

            for (int i = 0; i < length; ++ i) {
                if (i >= data1.length) {
                    return -1;
                }
                int c1 = data1[i];
                if (i >= data2.length) {
                    return 1;
                }
                int c2 = data2[i];
                if (c1 < c2) {
                    return -1;
                }
                if (c1 > c2) {
                    return 1;
                }
            }
            if (data1.length < data2.length) {
                return -1;
            }
            if (data1.length > data2.length) {
                return 1;
            }
            return 0;
        }
    }
}
