/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write tot he Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx10input;

import java.util.Vector;
import javax.swing.JLabel;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXMidiLogger;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.console.MXConsoleModel;
import jp.synthtarou.midimixer.libs.midi.MXMidiUI;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX10View extends javax.swing.JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX10View.class);
    MXConsoleModel _model;
    MX10Process _process;
    MX10MidiInListPanel _inPanel;
    JTableWithColumnHeader _jTableSkip;
    
    /**
     * Creates new form MX10
     */
    public MX10View(MX10Process process) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
        _process = process; 
        initComponents();

        _inPanel = new MX10MidiInListPanel();
        jPanelInputSelect.add(_inPanel);

        _jTableSkip = new JTableWithFooter(jPanel1);
        _jTableSkip.setModel(createSkipTableModel(_process._data));
        _jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
        _jTableSkip.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                if (_jTableSkip.isEnabled()) {
                    jTableSkip_MouseClicked(evt);
                }
            }
        });

        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(JLabel.CENTER);

        for (int i = 1; i < _jTableSkip.getColumnCount(); ++ i) {
            TableColumn col = _jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        
        jCheckBoxUseMessageFilter.setSelected(_process.isUseMessageFilter());
        jCheckBoxUsePortFowarding.setSelected(_process.isUsePortFowarding());
        jCheckBoxUseLogging.setSelected(_process.isUseLogging());

        _jTableSkip.setEnabled(_process.isUseMessageFilter());
        jPanel4.add(_process._patchBay.getReceiverView());
    }
    
    public void setLogger(MXMidiLogger logger) {    
        logger.attach(jList1);
    }

    private void jTableSkip_MouseClicked(java.awt.event.MouseEvent evt) {                                     
        int row = _jTableSkip.rowAtPoint(evt.getPoint());
        int column = _jTableSkip.columnAtPoint(evt.getPoint());
        
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)_jTableSkip.getModel();
        
        if (type >= 1 && type <= _process._data.TYPE_COUNT) {
            if (port >= 0 && port < MXStatic.TOTAL_PORT_COUNT) {
                if (_process._data.isSkip(port, type)) {
                    _process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                }else {
                    _process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }                                    

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane2 = new javax.swing.JSplitPane();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanelInputSelect = new javax.swing.JPanel();
        jPanelSkip = new javax.swing.JPanel();
        jCheckBoxUseMessageFilter = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        jSplitPane3 = new javax.swing.JSplitPane();
        jPanel2 = new javax.swing.JPanel();
        jCheckBoxUsePortFowarding = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList<>();
        jCheckBoxUseLogging = new javax.swing.JCheckBox();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jSplitPane2.setDividerLocation(240);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jSplitPane1.setDividerLocation(400);

        jPanelInputSelect.setBorder(javax.swing.BorderFactory.createTitledBorder("Assign Input (1)"));
        jPanelInputSelect.setLayout(new javax.swing.BoxLayout(jPanelInputSelect, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane1.setLeftComponent(jPanelInputSelect);

        jPanelSkip.setBorder(javax.swing.BorderFactory.createTitledBorder("Skip Which (2)"));
        jPanelSkip.setLayout(new java.awt.GridBagLayout());

        jCheckBoxUseMessageFilter.setText("Use This Recipe");
        jCheckBoxUseMessageFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseMessageFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelSkip.add(jCheckBoxUseMessageFilter, gridBagConstraints);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.LINE_AXIS));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelSkip.add(jPanel1, gridBagConstraints);

        jSplitPane1.setRightComponent(jPanelSkip);

        jSplitPane2.setLeftComponent(jSplitPane1);

        jSplitPane3.setDividerLocation(300);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Port Forwarding (3)"));
        jPanel2.setLayout(new java.awt.GridBagLayout());

        jCheckBoxUsePortFowarding.setText("Use This Recipe");
        jCheckBoxUsePortFowarding.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUsePortFowardingActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel2.add(jCheckBoxUsePortFowarding, gridBagConstraints);

        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.LINE_AXIS));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jPanel4, gridBagConstraints);

        jSplitPane3.setLeftComponent(jPanel2);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Logging (4)"));
        jPanel3.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jScrollPane1, gridBagConstraints);

        jCheckBoxUseLogging.setText("Use This Recipe");
        jCheckBoxUseLogging.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseLoggingActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel3.add(jCheckBoxUseLogging, gridBagConstraints);

        jSplitPane3.setRightComponent(jPanel3);

        jSplitPane2.setRightComponent(jSplitPane3);

        add(jSplitPane2);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxUseMessageFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseMessageFilterActionPerformed
        _process.setUseMesssageFilter(jCheckBoxUseMessageFilter.isSelected());
    }//GEN-LAST:event_jCheckBoxUseMessageFilterActionPerformed

    private void jCheckBoxUseLoggingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseLoggingActionPerformed
        _process.setUseLogging(jCheckBoxUseLogging.isSelected());
    }//GEN-LAST:event_jCheckBoxUseLoggingActionPerformed

    private void jCheckBoxUsePortFowardingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUsePortFowardingActionPerformed
        _process.setUsePortFowarding(jCheckBoxUsePortFowarding.isSelected());
    }//GEN-LAST:event_jCheckBoxUsePortFowardingActionPerformed

    public synchronized TableModel createSkipTableModel(MX10Data data) {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        model.addColumn("");
        
        for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
            model.addColumn(MXMidiUI.nameOfPort(i));
        }
        
        for (int row = 0; row < _process._data.TYPE_COUNT; ++ row) {
            Vector line = new Vector();
            line.add(data.typeNames[row]);
            
            for (int delivery = 0; delivery < MXStatic.TOTAL_PORT_COUNT; ++ delivery) {
                int type = row + 1; /* 1 -> 9 */
                if (data.isSkip(delivery, type)) {
                    line.add("Skip");
                }else {
                    line.add("");
                }
            }
            model.addRow(line);
        }
        if (true) {
            Vector line = new Vector();
            line.add("");

            for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
                line.add(MXMidiUI.nameOfPort(i));
            }
        }
        return model;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxUseLogging;
    private javax.swing.JCheckBox jCheckBoxUseMessageFilter;
    private javax.swing.JCheckBox jCheckBoxUsePortFowarding;
    private javax.swing.JList<String> jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanelInputSelect;
    private javax.swing.JPanel jPanelSkip;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JSplitPane jSplitPane3;
    // End of variables declaration//GEN-END:variables
}
