/*
 * Copyright (C) 2022 user0001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx12masterkeys;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SpinnerNumberModel;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMidiUI;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX12MasterPanelEditor extends javax.swing.JPanel {
    public static JDialog showAsDialog(JFrame parent, MX12Process process, boolean modal) {
        MX12MasterPanelEditor editor = new MX12MasterPanelEditor(process);
        JDialog dialog = new JDialog(parent, modal);
        dialog.setTitle(editor.getTitle());
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.setSize(500, 200);
        dialog.getContentPane().add(editor);
        MXUtil.centerWindow(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    public static JDialog showAsDialog(JDialog parent, MX12Process process, boolean modal) {
        MX12MasterPanelEditor editor = new MX12MasterPanelEditor(process);
        JDialog dialog = new JDialog(parent, modal);
        dialog.setTitle(editor.getTitle());
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.setSize(300, 200);
        dialog.getContentPane().add(editor);
        MXUtil.centerWindow(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    MXWrapList<Integer> _portModel;
    MXWrapList<Integer> _channelModel;
    MXWrapList<MXReceiver> _receiverModel;

    /**
     * Creates new form MX12MasterEditor
     */
    public MX12MasterPanelEditor(MX12Process process) {
        initComponents();
        _process = process;
        jLabel6.setText("");
        
        showParameters();
    }
   
    public void showParameters() {
        _receiverModel = MXMain.getMain().getMasterToList();
        jComboBoxReciever.setModel(_receiverModel);
        _receiverModel.setComboBox(jComboBoxReciever, _process.getNextReceiver());

        _portModel = MXMidiUI.createPort(false);
        jComboBoxPort.setModel(_portModel);
        _portModel.setComboBox(jComboBoxPort, _process._mousePort);
        
        _channelModel = MXMidiUI.createChannel(false);
        jComboBoxChannel.setModel(_channelModel);
        _channelModel.setComboBox(jComboBoxChannel, _process._mouseChannel);
        
        jSpinnerMouseVelocity.setModel(new SpinnerNumberModel(_process._mouseVelocity, 1, 127, 1));
        
        jCheckBoxOverwrite.setSelected(_process._overwriteControllerChannel);
    }
    
    public void catchParameters() {
        _process.setNextReceiver(_receiverModel.get(jComboBoxReciever.getSelectedIndex()).value);
        _process._mousePort = _portModel.get(jComboBoxPort.getSelectedIndex()).value;
        _process._mouseChannel = _channelModel.get(jComboBoxChannel.getSelectedIndex()).value;
        _process._mouseVelocity = (int)jSpinnerMouseVelocity.getValue();
        _process._overwriteControllerChannel = this.jCheckBoxOverwrite.isSelected();
    }

    MX12Process _process;
    
    public String getTitle() {
        return MXStatic.MX_APPNAME;
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jComboBoxReciever = new javax.swing.JComboBox<>();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxPort = new javax.swing.JComboBox<>();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxChannel = new javax.swing.JComboBox<>();
        jLabel4 = new javax.swing.JLabel();
        jSpinnerMouseVelocity = new javax.swing.JSpinner();
        jLabel5 = new javax.swing.JLabel();
        jCheckBoxOverwrite = new javax.swing.JCheckBox();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createTitledBorder("Master Key Controller"));
        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Receiver");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jComboBoxReciever, gridBagConstraints);

        jLabel2.setText("Port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jComboBoxPort, gridBagConstraints);

        jLabel3.setText("Channel");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jComboBoxChannel, gridBagConstraints);

        jLabel4.setText("Velocity(Mouse)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel4, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jSpinnerMouseVelocity, gridBagConstraints);

        jLabel5.setText("Port/Ch(External)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel5, gridBagConstraints);

        jCheckBoxOverwrite.setText("Overwrite");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jCheckBoxOverwrite, gridBagConstraints);

        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(jButton1, gridBagConstraints);

        jButton2.setText("Cancel");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(jButton2, gridBagConstraints);

        jLabel6.setText("jLabel6");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 1.0;
        add(jLabel6, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        catchParameters();
        MXUtil.closeDialog(this);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        MXUtil.closeDialog(this);
    }//GEN-LAST:event_jButton2ActionPerformed

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JCheckBox jCheckBoxOverwrite;
    private javax.swing.JComboBox<String> jComboBoxChannel;
    private javax.swing.JComboBox<String> jComboBoxPort;
    private javax.swing.JComboBox<String> jComboBoxReciever;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JSpinner jSpinnerMouseVelocity;
    // End of variables declaration//GEN-END:variables
}
