/*
 * Copyright (C) 2022 user0001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXMidiUI;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;

/**
 *
 * @author user0001
 */
public class MX20View extends javax.swing.JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX20View.class);

    MX20Process _process;
    
    JTableWithColumnHeader jTable;
    JScrollPane jScrollPane;

    /**
     * Creates new form MX20View
     */
    public MX20View(MX20Process process) {
        initComponents();
        _process = process;
        jTable = new JTableWithColumnHeader();
        TableModel model = createTableModel();
        jTable.setModel(model);
        
        jTable.setEnabled(_process.usingThis());
        jTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jTable_MousePressed(evt);
            }
        });
        jTable.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent e){
                if (jTable.getSelectedRow() < 0) {
                    return;
                }
                if (e.getKeyCode() == KeyEvent.VK_ENTER
                 || e.getKeyCode() == KeyEvent.VK_SPACE) {
                    popupOpenOrClose(jTable.getSelectedRow());
                }
            }
        });   

        TableColumnModel columnModel = jTable.getTableHeader().getColumnModel();
        
        columnModel.getColumn(0).setPreferredWidth(100);
        columnModel.getColumn(0).setMinWidth(100);
        columnModel.getColumn(0).setMaxWidth(100);

        if (process.isTypeInput()) {
            columnModel.getColumn(1).setPreferredWidth(100);
            columnModel.getColumn(1).setMinWidth(100);
            columnModel.getColumn(1).setMaxWidth(100);
        }
        
        jScrollPane = new JScrollPane(jTable);
        add(jScrollPane);

        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                int x = 1;
                int y = jTable.getSelectedRow();
                Rectangle rect = jTable.getCellRect(y, x, true);
                rect.y += jTable.getTableHeader().getHeight();
                jScrollPane.getVerticalScrollBar().scrollRectToVisible(rect);
            }
        });
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));
    }// </editor-fold>//GEN-END:initComponents

    public void setupViewFromModel() {
        TableModel model = createTableModel();
        jTable.setModel(model);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    public synchronized TableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        String inName;
        String outName;

        if (_process.isTypeInput()) {
            inName = "In ";
            outName = "Internal ";
        }else {
            inName = "Internal ";
            outName = "Out ";
        }
        model.addColumn("");
        model.addColumn("to " + outName);

        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            Vector line = new Vector();
            line.add(inName + MXMidiUI.nameOfPort(port));
            
            StringBuffer text = new StringBuffer();

            for (int delivery = 0; delivery < MXStatic.TOTAL_PORT_COUNT; ++ delivery) {
                if (_process.getData().isEnabled(port, delivery)) {
                    if (text.length() != 0) {
                        text.append(", ");
                    }
                    text.append(MXMidiUI.nameOfPort(delivery));
                }
            }
            line.add(text.toString());
            model.addRow(line);
        }
        return model;
    }

    public class ListenerForOpenOrClose implements ActionListener {
        int portnumber;
        int targetnumber;
        boolean flag;

        public ListenerForOpenOrClose(int from, int target, boolean setflag) {
            portnumber = from;
            targetnumber = target;
            flag = setflag;
        }
        
        @Override
        public void actionPerformed(ActionEvent e) {
            MX20Data data = _process.getData();
            data.set(portnumber, targetnumber, flag);
            setupViewFromModel();
            jTable.getSelectionModel().setSelectionInterval(portnumber, portnumber);
        }
    }

    public void popupOpenOrClose(int port) {
        try {
            MX20Data data = _process.getData();
            JPopupMenu jpopup = new JPopupMenu();

            for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
                boolean using = data.isEnabled(port, i);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(MXMidiUI.nameOfPort(i));
                if (using) {
                    item.setSelected(true);
                    item.addActionListener(new ListenerForOpenOrClose(port, i, false));
                }else {
                    item.addActionListener(new ListenerForOpenOrClose(port, i, true));
                }
                jpopup.add(item);
            }

            jpopup.show(jTable, jTable.getColumnModel().getColumns().nextElement().getWidth(), jTable.getRowHeight(0) * (port + 1));
        }catch(Throwable e) {
            e.printStackTrace();
        }   
    }

    public void jTable_MousePressed(MouseEvent evt)
    {
        int port = jTable.rowAtPoint(evt.getPoint());
        int column = jTable.columnAtPoint(evt.getPoint());

        if (port >= 0 && column == 1) {         
            popupOpenOrClose(port);
        }
    }
}
