/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx30controller.ui;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.swing.MXSpinnerMouseExt;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;
import jp.synthtarou.midimixer.libs.swing.MXFocusGroupElement;
import jp.synthtarou.midimixer.mx30controller.MX32PageProcess;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MGCircle extends javax.swing.JPanel implements MXFocusAble {
    private static final MXDebugConsole _debug = new MXDebugConsole(MGCircle.class);

    final int _row;
    final int _column;
    MX32PageProcess _process;
    Color foreground = null;
    boolean _disconnectMoment = false;
    
    public void setInverted(boolean invert) {
        jCircleValue.setInverted(invert);
    }

    public MGCircle(MX32PageProcess process, int row, int col) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
        _process = process;
        _row = row;
        _column = col;

        initComponents();
        jSpinnerValue.setVisible(false);

        new MXSpinnerMouseExt(MGCircle.this, jSpinnerValue);
        updateUI();
    }
    
    public void updateUI() {
        super.updateUI();

        if (_process != null && _process._data != null) {
            MXUIValue status = _process._data.getCircleStatus(_row, _column);

            jSpinnerValue.setModel(new SpinnerNumberModel(status.getValue(), status._uiValueMinimum, status._uiValueMaximum, 1));
            jCircleValue.setRange(status._uiValueMinimum, status._uiValueMaximum);
            jCircleValue.setInverted(status._uiValueInvert);

            status.setValue(status._uiValueDefault);
            updateUIOnly(status._uiValueDefault);
            jLabel1.setText(status._name);
            focusStatusChanged(false);
        }
    }

    ArrayList<MouseListener> backupedListener = new ArrayList();
    
    public void setValueChangeable(boolean usable) {
        if (usable == false) {            
            for (MouseListener l : jCircleValue.getMouseListeners()) {
                if (l instanceof MXFocusGroupElement.Listen) {
                    continue;
                }else {
                    backupedListener.add(l);
                }
            }
            for (MouseListener l : backupedListener) {
                jCircleValue.removeMouseListener(l);
            }
        }else {
            for (MouseListener l : backupedListener) {
                jCircleValue.addMouseListener(l);
            }
            backupedListener.clear();
        }
    }

    public void setBackground(Color col) {
        super.setBackground(col);
        if (jLabel1 != null) {
            jLabel1.setBackground(col);
        }
        if (jCircleValue != null) {
            jCircleValue.setBackground(col);
        }
    }

    public void setDefaultBackground() {
        int block = _column / 4;
        boolean toggle = (block % 2 == 0) ? true : false;
        if (toggle) {
            setBackground(MXStatic.colorSlider1);
        }else {
            setBackground(MXStatic.colorSlider2);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">                          
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCircleValue = new CurvedSlider(35);
        jLabel1 = new javax.swing.JLabel();
        jSpinnerValue = new javax.swing.JSpinner();

        setLayout(new java.awt.GridBagLayout());

        //jCircleValue.setOrientation(javax.swing.JSlider.VERTICAL);
        jCircleValue.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCircleValueStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jCircleValue, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        add(jLabel1, gridBagConstraints);

        jSpinnerValue.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerValueStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        add(jSpinnerValue, gridBagConstraints);
    }// </editor-fold>                        

    private void jCircleValueStateChanged(javax.swing.event.ChangeEvent evt) {                                          
        int newValue = jCircleValue.getValue();
        jSpinnerValue.setValue(newValue);
        if (_updating == newValue) {
            return;
        }
        _process._data.doUpdateCircle(_row, _column, newValue, false);
    }                                         

    private void jSpinnerValueStateChanged(javax.swing.event.ChangeEvent evt) {                                           
        Object value = jSpinnerValue.getValue();
        if (value instanceof Number) {
            int newValue = ((Number)value).intValue();
            jCircleValue.setValue(newValue);
            if (_updating == newValue) {
                return;
            }
            _process._data.doUpdateCircle(_row, _column, newValue, false);
        }
    }                                          
    
    int _updating = -1;
    
    public void updateUIOnly(int newValue) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    updateUIOnly(newValue);
                }
            });
            return;
        }
        
        _updating = newValue;
        
        _process._data.getCircleStatus(_row, _column).setValue(newValue);
        if (jCircleValue.getValue() != newValue) {
            jCircleValue.setValue(newValue);
        }
        try {
            if ((int)jSpinnerValue.getValue() != newValue) {
                jSpinnerValue.setValue(newValue);
            }
        }catch(Exception e) {
            e.printStackTrace();;
        }

        _updating = -1;
    }
    
    // Variables declaration - do not modify                     
    private javax.swing.JLabel jLabel1;
    private CurvedSlider jCircleValue;
    private javax.swing.JSpinner jSpinnerValue;
    // End of variables declaration                   

    @Override
    public void focusedMousePressed() {
        if (_process._parent._editingControl) {
            _process._parent.enterEditMode(false);
            focusStatusChanged(false);
            editContoller();
        }
    }

    @Override
    public void focusStatusChanged(boolean flag) {
        if (flag) {
            _process._parent.updateFocusInformation(MXUIValue.TYPE_CIRCLE, _process._port, _row, _column);
        }else {
            setDefaultBackground();
        }       
    }

    @Override
    public void focusChangingValue() {
        _process._parent.updateFocusInformation(MXUIValue.TYPE_CIRCLE, _process._port, _row, _column);
    }

    public void increment() {
        MXUIValue status = _process._data.getCircleStatus(_row, _column);  
        int newValue = status.getValue() + 1;
        if (status._uiValueInvert) {
            newValue = status.getValue() - 1;
        }
        if (newValue > status._uiValueMaximum) {
            newValue = status._uiValueMaximum;
        }
        if (newValue < status._uiValueMinimum) {
            newValue = status._uiValueMinimum;
        }
        if (newValue != status.getValue()) {
            _process._data.doUpdateCircle(_row, _column, newValue, false);
        }
    }
    
    public void decriment() {
        MXUIValue status = _process._data.getCircleStatus(_row, _column);
        int newValue = status.getValue() - 1;
        if (status._uiValueInvert) {
            newValue = status.getValue() + 1;
        }
        if (newValue < status._uiValueMinimum) {
            newValue = status._uiValueMinimum;
        }
        if (newValue != status.getValue()) {
            _process._data.doUpdateCircle(_row, _column, newValue, false);
        }
    }

    public void editContoller() { 
        _process._parent.enterEditMode(false);
        MXUIValue status = _process._data.getCircleStatus(_row, _column);
        MXUIValueConfig config = new MXUIValueConfig(status);
        MXUtil.showAsDialog(this, config, "Edit " + ui.toString());
        if (config._okOption) {
            MXMessage message = MXMessageFactory.fromDtext(config._textAfter);
            message.setPort(_process._port);
            if (message.isMessageTypeChannel()) {
                message.setChannel(config._channelAfter);
            }
            if (message.hasGateField()) {
                message.setGate(config._gateAfter);
            }
            status.setMonitoring(message);
            status._name = config._nameAfter;
            jLabel1.setText(status._name);
        }
    }
}
