/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs;


import java.io.PrintStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXDebugConsole {
    private static final MXDebugConsole debug = new MXDebugConsole(MXDebugConsole.class);
    private PrintStream _console = System.out;
    
    public static void dumpEnv() {
        if (debug.isDebug()) {
            Properties props = System.getProperties();
            Enumeration keys = props.keys();
            debug.println("System.getProperties = ");
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                debug.println("    " + key + " = " + value);
            }

            Map<String, String> envs = System.getenv();
            debug.println("System.getenv = ");
            for (String key : envs.keySet()) {
                String value = (String)envs.get(key);
                debug.println("    " + key + " = " + value);
            }
        }

    }
    
    public static void main(String[] args) {
        debug.switchOn();
        debug.printStackTrace();

        dumpEnv();
        
        test();
    }
    
    public static void test() {
        debug.printStackTrace(new Throwable());
    }
    
    protected String _name;
    
    public MXDebugConsole(Class cls) {
        _name = cls.getName();
        if (_name != null) {
            int x = _name.lastIndexOf('.');
            if (x >= 0) {
                _name = _name.substring(x+1);
            }
            if (_target == null) {
                //when 1st initialize, i happens
                return;
            }
            if (_target.contains(_name)) {
                _switch = true;
            }
        }
    }
    
    public boolean isDebug() {
        return (_globalSwitch || _switch);
    }
    
    public void println(String text) {
        if (isDebug()) {
            _console.println(_name + ": " + text);
        }
    }

    public void print(String text) {
        if (isDebug()) {
            _console.print(_name + ": " + text);
        }
    }

    public void println() {
        if (isDebug()) {
            _console.println(_name + ": ");
        }
    }

    public void printStackTrace() {
        if (isDebug()) {
            Throwable th= new Throwable();
            StackTraceElement[] elems = th.getStackTrace();
            _console.println("print stack trace = ");
            for (int i = 1 ; i < elems.length; ++ i) {
                StackTraceElement x = elems[i];
                _console.println("    "  + x);
            }
        }
    }

    public void printStackTrace(Throwable th) {
        if (isDebug()) {
            StackTraceElement[] elems = th.getStackTrace();
            _console.println("print stack trace = " + th.getClass() + ":" + th.getMessage());
            for (int i = 0 ; i < elems.length; ++ i) {
                StackTraceElement x = elems[i];
                _console.println("    "  + x);
            }
        }
    }

    public void printStackTrace(Throwable th, String text) {
        if (isDebug()) {
            println(text);
            printStackTrace(th);
        }
    }

    private boolean _switch = false;
    private static boolean _globalSwitch = false;
    private static HashSet<String> _target = new HashSet();

    public static void initDebugConsole(String[] args) {
        String debug1 = System.getenv("DEBUG");
        String debug2 = System.getProperty("DEBUG");
        
        Comparator<String> ignoreCase = new Comparator<String>() {
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        };
        TreeSet<String> test = new TreeSet(ignoreCase);
        test.add("true");
        test.add("yes");
        test.add("on");
        test.add("1");
        if (debug1 != null && test.contains(debug1)) {
            _globalSwitch = true;
        } else if (debug2 != null && test.contains(debug2)) {
            _globalSwitch = true;
        } else {
            if (debug1 != null) {
                _target.add(debug1);
            }
            if (debug2 != null) {
                _target.add(debug2);
            }
        }
        for (int i = 0; i < args.length; ++ i) {
            if (args[i].equalsIgnoreCase("--debug")) {
                _globalSwitch = true;
            }
        }
    }
   
    public static void parseArgs(String[] args) {
        for (String text : args) {
            if (text.startsWith("--debug=")) {
                _target.add(text.substring(8));
            }else if (text.equals("--degbug")) {
                _globalSwitch = true;
            }
        }
    }
    
    public static void globalSwitchOn() {
        _globalSwitch = true;
    }

    public static void globalSwitchOff() {
        _globalSwitch = false;
    }

    public void switchOn() {
        _switch = true;
    }

    public void switchOff() {
        _switch = false;
    }
}
