/*
 * Copyright (C) 2022 user0001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import javax.swing.JComponent;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXParaoutReceiver extends MXReceiver {
    ArrayList<MXReceiver> list = new ArrayList();
    
    public MXParaoutReceiver() {
        
    }

    public MXParaoutReceiver(MXReceiver p1, MXReceiver p2) {
        list.add(p1);
        list.add(p2);
    }

    public MXParaoutReceiver(MXReceiver[] array) {
        for(MXReceiver x : array) {
            list.add(x);
        }
    }
    
    @Override
    public void processMXMessage(MXMessage message) {
        for(MXReceiver x : list) {
            x.processMXMessage(message);
        }
    }

    @Override
    public String getReceiverName() {
        return "Parallel";
    }

    @Override
    public JComponent getReceiverView() {
        return null;
    }
}
