/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs.midi;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugConsole;

/**
 *
 * @author YOSHIDA Shintarou
 */
public abstract class MXReceiver {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXReceiver.class);
    private static MXMain _lock = MXMain.getMain();
    
    public abstract String getReceiverName();

    public abstract JComponent getReceiverView();
    
    private MXReceiver _nextReceiver;

    public final MXReceiver getNextReceiver() {
        return _nextReceiver;
    }

    public void setNextReceiver(MXReceiver next) {
        _nextReceiver = next;
    }
    
    public abstract void processMXMessage(MXMessage message);
    /* implements like following
     *      public void processMXMessage(MXMessage message) {
     *          if (usingThis() == false) {
     *              sendToNext(message);
     *              return;
     *          }
     *      .......
    */
    public final void sendToNext(MXMessage message) {
        if (_nextReceiver != null) {
            synchronized(_lock) {
                _nextReceiver.processMXMessage(message);
            }
        }else {
            _debug.println("receiver not set " + message);
            _debug.printStackTrace();
        }
    }

    boolean _usingThis = true;
    
    public final boolean isUsingThisRecipe() {
        return _usingThis;
    }

    public final void setUsingThisRecipe(boolean usingThis) {
        _usingThis = usingThis;
    }
}
