/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs.midi.capture;

import java.util.TreeMap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMessageCapture {
    TreeMap<String, TextInformation> _captureData = new TreeMap();

    public MXMessageCapture() {
    }
    
    public void clear() {
        _captureData = new TreeMap();
        age = 0;
    }
    
    public int age = 0;
    
    public void process(MXMessage message) {
        int channel = message.getChannel();
        int gate = message.getGate();
        int value = message.getValue();
        String dtext = MXMessageFactory.toDText(message);

        synchronized(this) {
            TextInformation textNode = _captureData.get(dtext + channel);
            if (textNode == null) {
                textNode = new TextInformation();
                textNode.dtext = dtext;
                textNode.command = message.getCommand();
                textNode.channel = message.getChannel();
                age ++;
                _captureData.put(dtext + message.getChannel(), textNode);
            }

            GateInfomation gateNode = textNode.listGateValues.get(gate);
            if (gateNode == null) {
                gateNode = new GateInfomation();
                gateNode._gate = gate;
                gateNode._maxValue = value;
                gateNode._minValue = value;
                gateNode._parent = textNode;
                textNode.listGateValues.put(gate, gateNode);
                age ++;
                return;
            }
            if (gateNode._minValue > value) {
                gateNode._minValue = value;
                age ++;
            }
            if (gateNode._maxValue < value) {
                gateNode._maxValue = value;
                age ++;
            }
            notifyAll();
        }
    }
    
    public int getAge() {
        return age;
    }

    public String nameOf(GateInfomation gate) {
        TextInformation text = gate._parent;

        //MXMessage messageMin = MXMessageFactory.fromDtext(text.dtext, gate._gate, gate._minValue);
        int port = 0;
        MXMessage message = MXMessageFactory.fromDtext(text.dtext, port, gate._parent.channel, gate._gate, gate._maxValue);

        return  message.toStringHeader(gate._minValue, gate._maxValue);
    }
    
    public MXWrapList<GateInfomation> createListModel() {
        synchronized(this) {
            MXWrapList<GateInfomation> list = new MXWrapList<>();

            TreeMap<String, TextInformation> capture = _captureData;
            for (TextInformation text : capture.values()) {
                for (GateInfomation gate : text.listGateValues.values()) {
                    list.addNameAndValue(nameOf(gate), gate);
                }
            }
            return list;
        }
    }
}
