/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import javax.swing.JPanel;
import jp.synthtarou.midimixer.MXMidiLogger;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMidi;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.mx40layer.MXChannelInfoReceiver;

/**
 *
 * @author YOSHIDA Shintarou
 */

public class FinalMIDIOut extends MXReceiver {
    private static final MXDebugConsole _debug = new MXDebugConsole(FinalMIDIOut.class);

    protected static final FinalMIDIOut _instance = new FinalMIDIOut();
    
    public static FinalMIDIOut getInstance() {
        return _instance;
    }
    
    final MXChannelInfoReceiver _outputInfo = new MXChannelInfoReceiver();
    
    public MXChannelInfoReceiver getOutputInfo() {
        return _outputInfo;
    }

    private MXMidiLogger _logger = new MXMidiLogger("Out");
    
    public MXMidiLogger getLogger() {
        return _logger;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        //if (usingThis() == false) { sendToNext(message); return; }
        _outputInfo.processMXMessage(message);
        _logger.processMXMessage(message);
        MXMIDIOut out = MXMIDIOutManager.getManager().findMIDIOutput(message.getPort());
        if (out == null) {
            //_debug.println("output not assigned");
            return;
        }
        if (out.isOpen() == false) {
            //_debug.println("output not opened");
            return;
        }
        out.processMidiOut(message);
    }

    @Override
    public String getReceiverName() {
        return "Dispatch To Device";
    }

    @Override
    public JPanel getReceiverView() {
        return null;
    }
}
