/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMidi;

/**
 *
 * @author yaman
 */
public class SMFMessage implements Comparable<SMFMessage> {

    /**
     * @return the dataType
     */
    public int getDataType() {
        return _dataType;
    }

    /**
     * @param dataType the dataType to set
     */
    public void setDataType(int dataType) {
        this._dataType = dataType;
    }

    /**
     * @return the _status
     */
    public int getStatus() {
        return _status;
    }

    /**
     * @param _status the _status to set
     */
    public void setStatus(int _status) {
        this._status = _status;
    }

    /**
     * @return the _data1
     */
    public int getData1() {
        return _data1;
    }

    /**
     * @param data the _data1 to set
     */
    public void setData1(int data) {
        this._data1 = data;
    }

    /**
     * @return the _data2
     */
    public int getData2() {
        return _data2;
    }

    /**
     * @param data2 the _data2 to set
     */
    public void setData2(int data2) {
        this._data2 = data2;
    }

    /**
     * @return the _binary
     */
    public byte[] getBinary() {
        if (_binary != null) {
            byte[] binary = _binary;
            return _binary.clone();
        }else {
            return null;
        }
    }

    /**
     * @param binary the _binary to set
     */
    public void setBinary(byte[] binary) {
        this._binary = binary.clone();
        if (binary.length >= 3 && binary[0] == 0) {
            new Throwable(MXUtil.dumpHexFF(binary)).printStackTrace();
        }
    }
    long _tick;
    
    public long getTick() {
        return _tick;
    }

    public SMFMessage(long tick, int status, int data1, int data2) {
        _tick = tick;
        _status = status;
        _data1 = data1;
        _data2 = data2;
        _binary = null;
    }

    public SMFMessage(long tick, int status, int dataType, byte[] binary) {
        _tick = tick;
        _status = status;
        _dataType = dataType;
        _data1 = 0;        
        _data2 = 0;
        _binary = binary;
    }

    private int _status;
    private int _data1;
    private int _data2;
    private byte[] _binary;
    
    public String toString() {
        byte[] data = getBinary();
        if (data != null)
        {
            data = data.clone();
            if (getStatus() == 0xff) {
                String meta = "";
                try {
                    meta = dumpHexFF(data);
                    meta = new String(data, "ISO-8859-1");
                    meta = new String(data, "Shift_JIS");
                }catch(Exception e) {
                    
                }
                return meta;
            }else {
                
            }
            return toHexFF(getStatus()) + " -> " + dumpHexFF(data);
        }else {
            return toHexFF(getStatus()) + ", " + toHexFF(getData1()) + ", " + toHexFF(getData2());
        }
    }

    public static String toHexFF(int i) {
        String str = Integer.toHexString(i).toUpperCase();
        if (str.length() == 1) {
            return "0" + str;
        }
        if (str.length() >= 3) {
            return str.substring(str.length() - 2, str.length());
        }
        return str;
    }

    public static String dumpHexFF(byte[] data) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                str.append(" ");
            }
            str.append(toHexFF((int) data[i]));
        }
        return str.toString();
    }

    public MXMessage toMXMessage() {
        MXMessage message = null;

        if (getStatus() >= 0x80 && getStatus() <= 0xef) {
            message = MXMessageFactory.fromShortMessage(0, getStatus(), getData1(), getData2());
        }
        else if (getStatus() == 0xf0 && getStatus() == 0xf7) {
            message = MXMessageFactory.fromSysexMessage(0, getStatus(), getBinary());
        }
        else if (getStatus() == 0xff) {
            message = MXMessageFactory.fromMeta(0, getData1(), getBinary());
        }
        else {
            //Bug
        }
        return message;
    }

    @Override
    public int compareTo(SMFMessage o) {
        SMFMessage o1 = this;
        SMFMessage o2 = o;
        long x;
        x = o1._tick - o2._tick;
        if (x < 0) return -1; if (x > 0) return 1;
        
        boolean isProg1 = (o1.getStatus() & 0xf0) == MXMidi.COMMAND_PROGRAMCHANGE;
        boolean isProg2 = (o2.getStatus() & 0xf0) == MXMidi.COMMAND_PROGRAMCHANGE;
        boolean isBank1 = (o1.getStatus() & 0xf0) == MXMidi.COMMAND_CONTROLCHANGE && (o1.getData1() == 0 || o1.getData1() == 32);
        boolean isBank2 = (o2.getStatus() & 0xf0) == MXMidi.COMMAND_CONTROLCHANGE && (o2.getData1() == 0 || o2.getData1() == 32);

        if (isProg1 && !isProg2) return -1;
        if (!isProg1 && isProg2) return 1;

        if (isBank1 && !isBank2) return -1;
        if (!isBank1 && isBank2) return 1;
        
        x = o1.getStatus() - o2.getStatus();
        if (x < 0) return -1; if (x > 0) return 1;
        x = o1.getData1() - o2.getData1();
        if (x < 0) return -1; if (x > 0) return 1;
        x = o1.getData2() - o2.getData2();
        if (x < 0) return -1; if (x > 0) return 1;
        if (o1.getBinary() != null || o2.getBinary() != null) {
            if (o2.getBinary() == null) return -1;
            if (o1.getBinary() == null) return  1;

            int len = o1.getBinary().length - o2.getBinary().length;
            if (len != 0) return len;

            for (int i = 0; i < o1.getBinary().length; ++ i) {
                x = o1.getBinary()[i] - o2.getBinary()[i];
                if (x < 0) return -1; if (x > 0) return 1;
            }
        }
        return 0;
    }
    
    public int getMetaTempo() {
        int b1 = (0xff & _binary[0]) << 16;
        int b2 = (0xff & _binary[1]) << 8;
        int b3 = (0xff & _binary[2]);
        return b1 + b2 + b3;
    }
    
    public boolean isMetaMessage() {
        return (_status == 0xff) ? true : false;
    }
   
    private int _dataType;
    
    public MidiMessage toJavaMessage() throws InvalidMidiDataException{
        if (_status == 0xff) {
            return new MetaMessage(getDataType(), _binary, _binary.length);
        }
        if (_status == 0xf0 || _status == 0xf7) {
            return new SysexMessage(_status, _binary, _binary.length);
        }
        return new ShortMessage(_status, _data1, _data2);
    }
}
