/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx00playlist;

import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.settings.MXSettingNode;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX00Process extends MXReceiver implements MXSettingTarget {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX00Process.class);

    public MX00Process() {
        _playListModel = new DefaultListModel();
        _setting = new MXSetting("PlayList");
        _setting.setTarget(this);

        _view = new MX00View(this);
    }

    public void readSettings() {
        _setting.readFile();

        if (_playListModel.size() == 0) {
            _playListModel.addElement(new FileWithId(new File("SynthTAROU000.mid")));
            _playListModel.addElement(new FileWithId(new File("SynthTAROU001.mid")));
            _playListModel.addElement(new FileWithId(new File("SynthTAROU002.mid")));
        }

        _view.settingUpdated();
    }
    
    MX00View _view;
    FileWithId _file;
    DefaultListModel _playListModel;
    MXSetting _setting;
    boolean _playAsChained;
    boolean _playAsRepeated;
    
    @Override
    public String getReceiverName() {
        return "SMF Player";
    }

    @Override
    public JComponent getReceiverView() {
        return _view;
    }
    @Override
    public void prepareSettingFields(jp.synthtarou.midimixer.libs.settings.MXSetting config) {
        config.register("playAsLooped");
        config.register("playAsChained");
        config.register("song[]");
    }

    @Override
    public void afterReadSettingFile(jp.synthtarou.midimixer.libs.settings.MXSetting config) {
        _playListModel.clear();

        _playAsRepeated = config.getSettingAsBoolean("playAsLooped", false);
        _playAsChained = config.getSettingAsBoolean("playAsChained", false);
        
        List<MXSettingNode> nodeList  = _setting.findByPath("song[]");
        int min = 100000;
        int max = -1;
        for (MXSettingNode node : nodeList) {
            String name = node.getName();
            try {
                int x = Integer.parseInt(name);
                if (x < min) min = x;
                if (x > max) max = x;
            }catch(NumberFormatException e) {
                _debug.printStackTrace(e);
            }
        }
        for (int x = min; x <= max; ++ x) {
            String value = config.getSetting("song[" + x + "]");
            if (value != null && value.length() > 0) {
                FileWithId file = new FileWithId(new File(value));
                _playListModel.addElement(file);
            }
        }
    }

    @Override
    public void beforeWriteSettingFile(jp.synthtarou.midimixer.libs.settings.MXSetting config) {
        config.clearValue();
        config.setSetting("playAsLooped", _playAsRepeated);
        config.setSetting("playAsChained", _playAsChained);

        for (int i = 0; i < _playListModel.getSize(); ++ i) {
            FileWithId f = (FileWithId)_playListModel.get(i);
            config.setSetting("song[" + (i + 1) + "]", f._file.getPath());
        }
    }

    @Override
    public void processMXMessage(MXMessage message) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
}
