/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;
import jp.synthtarou.midimixer.libs.swing.MXFocusGroupElement;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MGCircle extends javax.swing.JPanel implements MXFocusAble {
    private static final MXDebugConsole _debug = new MXDebugConsole(MGCircle.class);

    MX32MixerProcess _process;
    int _row, _column;
    Color foreground = null;
    boolean _disconnectMoment = false;
    
    public MGStatus getStatus() {
        if (_process == null) return null;
        return _process._data.getCircleStatus(_row, _column);
    }
    
    public void setStatus(MGStatus status) {
        _process._data.setCircleStatus(_row, _column, status);
    }

    public void setInverted(boolean invert) {
        jCircleValue.setInverted(invert);
    }

    public MGCircle(MX32MixerProcess process, int row, int column) {
        _row = row;
        _column = column;
        _process = process;

        initComponents();

        updateUI();
    }
    
    public void updateUI() {
        MGStatus status = getStatus();
        if (status != null) {
            status.fixRangedValue();
            jCircleValue.setRange(status.getRangeMin(), status.getRangeMax());
            jCircleValue.setInverted(status.isUiValueInvert());
            jCircleValue.setValue(status.getValue());

            if (status.getName() == null || status.getName().length() == 0) {
                MXMessage message = status.toMXMessage();
                if (message == null) {
                    jLabel1.setText("??");
                }else {
                    jLabel1.setText(message.toShortString());
                }
            }else {
                jLabel1.setText(status.getName());
            }
            focusStatusChanged(false);
        }
        super.updateUI();
    }

    ArrayList<MouseListener> backupedListener = new ArrayList();
    
    public void setValueChangeable(boolean usable) {
        if (usable == false) {            
            for (MouseListener l : jCircleValue.getMouseListeners()) {
                if (l instanceof MXFocusGroupElement.Listen) {
                    continue;
                }else {
                    backupedListener.add(l);
                }
            }
            for (MouseListener l : backupedListener) {
                jCircleValue.removeMouseListener(l);
            }
        }else {
            for (MouseListener l : backupedListener) {
                jCircleValue.addMouseListener(l);
            }
            backupedListener.clear();
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">                          
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCircleValue = new CurvedSlider(35);
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        //jCircleValue.setOrientation(javax.swing.JSlider.VERTICAL);
        jCircleValue.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCircleValueStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jCircleValue, gridBagConstraints);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
    }// </editor-fold>                        

    private void jCircleValueStateChanged(javax.swing.event.ChangeEvent evt) {                                          
        int newValue = jCircleValue.getValue();
        if (_updating == newValue) {
            return;
        }
        _process.catchedValue(getStatus(), newValue, null);
    }                                         

    int _updating = -1;
    
    public void updateUIOnly(int newValue) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    updateUIOnly(newValue);
                }
            });
            return;
        }
        
        _updating = newValue;
        
        getStatus().setValue(newValue);
        if (jCircleValue.getValue() != newValue) {
            jCircleValue.setValue(newValue);
        }

        _updating = -1;
    }
    
    // Variables declaration - do not modify                     
    private javax.swing.JLabel jLabel1;
    private CurvedSlider jCircleValue;
    // End of variables declaration                   

    @Override
    public void focusedMousePressed() {
        if (_process._parent._editingControl) {
            _process._parent.enterEditMode(false);
            focusStatusChanged(false);
            editContoller();
        }
    }

    @Override
    public void focusStatusChanged(boolean flag) {
        if (flag) {
            _process._parent.showTextForFocus(MGStatus.TYPE_CIRCLE, _process._port, _row, _column);
        }       
    }

    @Override
    public void focusChangingValue() {
        _process._parent.showTextForFocus(MGStatus.TYPE_CIRCLE, _process._port, _row, _column);
    }

    public void increment() {
        MGStatus status = getStatus();
        int newValue = status.getValue()+ 1;
        if (status.isUiValueInvert()) {
            newValue = status.getValue() - 1;
        }
        if (newValue > status.getRangeMax()) {
            newValue = status.getRangeMax();
        }
        if (newValue < status.getRangeMin()) {
            newValue = status.getRangeMin();
        }
        if (newValue != status.getValue()) {
            _process.catchedValue(status, newValue, null);
        }
    }
    
    public void decriment() {
        MGStatus status = getStatus();
        int newValue = status.getValue() - 1;
        if (status.isUiValueInvert()) {
            newValue = status.getValue() + 1;
        }
        if (newValue > status.getRangeMax()) {
            newValue = status.getRangeMax();
        }
        if (newValue < status.getRangeMin()) {
            newValue = status.getRangeMin();
        }
        if (newValue != status.getValue()) {
            _process.catchedValue(status, newValue, null);
        }
    }

    public void editContoller() { 
        _process._parent.enterEditMode(false);
        MGStatusConfig config = new MGStatusConfig(_process, getStatus());
        MXUtil.showAsDialog(this, config, "Enter Edit Circle {row:" + _row + ", column:" + _column + "}");
        if (config._okOption) {
            setStatus(config._status);
            jLabel1.setText(config._status.getName());
            _process.notifyCacheBroken();
            updateUI();
        }
    }
}
