/*
 * Copyright (C) 2022 user0001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx40layer;

import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMidi;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXChannelInfo {
    public int _bankMSB;
    public int _bankLSB;

    public boolean _havingBank;
    public int _program;
    public boolean  _havingProgram;

    public int _infoVolume = 127;
    public int _infoExpression = 127;
    public int _infoPan = 64;
    
    public int _dataentryType = MXMidi.DATAENTRY_TYPE_NONE;
    public int _dataentryMSB = 0;
    public int _dataentryLSB = 0;
    public int _dataentryValue = 0;

    public String toString() {
        String str = "";

        if (_havingBank) {
            String bankText = "[" + MXUtil.toHexFF(_bankMSB)
                    + ":" + MXUtil.toHexFF(_bankLSB) + "]";
            str += bankText;
        }
        if (_havingProgram) {
            String progName = " " + _program; // + ":" + GMProgramList.getInstance().nameOfValue(_program)
            str += progName;
        }

        return str;
    }
}
