/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer;

import java.awt.Color;
import javax.swing.JLabel;

/**
 *
 * @author YOSHIDA Shintarou
 */

public class MXStatic {
    public static final String LOOPMIDI_NAME = "EX MIDIMixer Out";
    public static final String MX_APPNAME = "MIX Recipe";
    public static final String MX_APPNAME_WITH_VERSION = "MIX Recipe - V0.04B (MIDI Mixer)";
    public static final String MX_EDITING = "*** EDIT CONTROl MODE ***";
    public static final int DRUM_CH = 9;
    
    static final MXStatic _setting = new MXStatic();
    public static final int TOTAL_PORT_COUNT = 16;

    public static final int SLIDER_COLUMN_COUNT = 17;
    public static final int SLIDER_ROW_COUNT = 1;
    public static final int CIRCLE_ROW_COUNT = 4;
    public static final int DRUM_ROW_COUNT = 2;

    public static boolean _trapMouseForOnlySelect = false;

    public static final Color colorSlider1 = mixedColor(mixedColor(Color.blue, Color.lightGray, 50), Color.white, 50);
    public static final Color colorSlider2 = mixedColor(colorSlider1, Color.white, 50);
    
    public static Color mixedColor(Color left, Color right, int percent) {
        int lr = (int) (left.getRed() * (100 - percent) / 100);
        int lg = (int) (left.getGreen() * (100 - percent) / 100);
        int lb = (int) (left.getBlue() * (100 - percent) / 100);
        int rr = (int) (right.getRed() * percent / 100);
        int rg = (int) (right.getGreen() * percent / 100);
        int rb = (int) (right.getBlue() * percent / 100);
        return new Color(lr + rr, lg + rg, lb + rb);
    }
}
