/*
 * Copyright (C) 2022 user0001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.NoneCriticalTimer;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXButtonUILabel {
    String _title;
    JLabel _toInstall;

    public MXButtonUILabel(JLabel toInstall, String title, Runnable run) {
        _title = title;
        _toInstall = toInstall;
        _toInstall.setText(title);
        setSelected(false);
        toInstall.addMouseListener(new MouseAdapter() { 

            @Override
            public void mouseReleased(MouseEvent e) {
                setSelected(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                setSelected(true);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (run != null) {
                    run.run();
                }
            }
        });
    }
    
    public JLabel getLabel() {
        return _toInstall;
    }
    
    public Dimension getSize() {
        return _toInstall.getSize();
    }

    long timer = 0;
    
    public void setSelected(boolean push) {
        if (push) {
            _toInstall.setIcon(new SelectedButtonIcon(_title));
            timer = System.currentTimeMillis();
            NoneCriticalTimer.push(100, new Runnable() {
                public void run() {
                    if (timer + 100 >= System.currentTimeMillis()) {
                        _toInstall.setIcon(new ButtonIcon(_title));
                    }
                }
            });
        }else {
            if (timer == 0) {
                _toInstall.setIcon(new ButtonIcon(_title));
            }
            timer = System.currentTimeMillis();
            NoneCriticalTimer.push(100, new Runnable() {
                public void run() {
                    if (timer + 100 >= System.currentTimeMillis()) {
                        _toInstall.setIcon(new ButtonIcon(_title));
                    }
                }
            });
        }
    }

    class ButtonIcon implements Icon {
        private final JButton _component;

        public ButtonIcon(String text) {
            _component = new JButton(text);
        }

        @Override public int getIconWidth() {
            return Math.max(getSize().width, _component.getPreferredSize().width);
        }

        @Override public int getIconHeight() {
            return Math.max(getSize().height, _component.getPreferredSize().height);
        }

        @Override public void paintIcon(Component c, Graphics g, int x, int y) {
            _component.setSize(new Dimension(getIconWidth(), getIconHeight()));
            SwingUtilities.paintComponent(g, _component, c.getParent(), x, y, getIconWidth(), getIconHeight());
        }
    }

    class SelectedButtonIcon implements Icon {
        private final JToggleButton _component;

        public SelectedButtonIcon(String text) {
            _component = new JToggleButton(text);
            _component.setSelected(true);
        }

        @Override public int getIconWidth() {
            return Math.max(getSize().width, _component.getPreferredSize().width);
        }

        @Override public int getIconHeight() {
            return Math.max(getSize().height, _component.getPreferredSize().height);
        }

        @Override public void paintIcon(Component c, Graphics g, int x, int y) {
            _component.setSize(new Dimension(getIconWidth(), getIconHeight()));
            SwingUtilities.paintComponent(g, _component, c.getParent(), x, y, getIconWidth(), getIconHeight());
        }
    }
}
