/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx30controller;

import jp.synthtarou.midimixer.mx30controller.ui.MGDrum;
import jp.synthtarou.midimixer.mx30controller.ui.MGCircle;
import jp.synthtarou.midimixer.mx30controller.ui.MGSlider;
import jp.synthtarou.midimixer.mx30controller.ui.MXUIValue;
import java.awt.Color;
import jp.synthtarou.midimixer.libs.swing.MXFocusGroup;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMidiUI;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX32PageView extends javax.swing.JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX32PageView.class);

    MX32PageProcess _process;
    MXFocusGroup _focusGroup;
    MXWrapList<Integer> chainModel;

    public MX32PageView(MX32PageProcess process) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
        int port = process._port;
        _process = process;
        
        initComponents();
        
        // following must here (late bind not work)
        chainModel = new MXWrapList<Integer>();
        chainModel.addNameAndValue(MXMidiUI.nameOfPort(-1), -1);
        for (int p2 = 0; p2 < MXStatic.TOTAL_PORT_COUNT; ++ p2) {
            if (p2 == port) {
                continue;
            }
            chainModel.addNameAndValue(MXMidiUI.nameOfPort(p2), p2);
        }

        jComboBoxChain.setModel(chainModel);

        if (port == 0) {
            SwingUtilities.invokeLater(new Runnable() { 
                public void run() {
                    _process._parent.updateFocusInformation(MXUIValue.TYPE_SLIDER,  0, 0, 0);
                }
            });
        }
        jLabelKeyTracker.setFocusable(true);
        jSplitPane1.setDividerLocation(getWidth() - 250);
    }
  
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane1 = new javax.swing.JSplitPane();
        jPanelControllers = new javax.swing.JPanel();
        jPanelSyncTo = new javax.swing.JPanel();
        jComboBoxChain = new javax.swing.JComboBox<>();
        jCheckBoxSyncTogether = new javax.swing.JCheckBox();
        jPanelEdit = new javax.swing.JPanel();
        jButton3 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListABC = new javax.swing.JList<>();
        jLabelKeyTracker = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jButtonImport = new javax.swing.JButton();
        jButtonExport = new javax.swing.JButton();

        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });
        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jSplitPane1.setDividerLocation(500);

        jPanelControllers.setLayout(new javax.swing.BoxLayout(jPanelControllers, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane1.setLeftComponent(jPanelControllers);

        jPanelSyncTo.setLayout(new java.awt.GridBagLayout());

        jComboBoxChain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxChainActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanelSyncTo.add(jComboBoxChain, gridBagConstraints);

        jCheckBoxSyncTogether.setText("MeTOO (OUT SIGNAL)");
        jCheckBoxSyncTogether.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSyncTogetherActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelSyncTo.add(jCheckBoxSyncTogether, gridBagConstraints);

        jPanelEdit.setBorder(javax.swing.BorderFactory.createTitledBorder("Target Information"));
        jPanelEdit.setLayout(new java.awt.GridBagLayout());

        jButton3.setText("Edit");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanelEdit.add(jButton3, gridBagConstraints);

        jScrollPane1.setViewportView(jListABC);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelEdit.add(jScrollPane1, gridBagConstraints);

        jLabelKeyTracker.setForeground(new JLabel().getBackground());
        jLabelKeyTracker.setText("<HTML>PC Key<br>[Cursor]<br>[Space]<br>[Back:]</HTML>");
        jLabelKeyTracker.setFocusCycleRoot(true);
        jLabelKeyTracker.setFocusTraversalPolicyProvider(true);
        jLabelKeyTracker.setVerifyInputWhenFocusTarget(false);
        jLabelKeyTracker.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jLabelKeyTrackerFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                jLabelKeyTrackerFocusLost(evt);
            }
        });
        jLabelKeyTracker.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jLabelKeyTrackerKeyPressed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanelEdit.add(jLabelKeyTracker, gridBagConstraints);
        jLabelKeyTracker.getAccessibleContext().setAccessibleName("Try Cursor<br>&Space+Back<br>");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        jPanelSyncTo.add(jPanelEdit, gridBagConstraints);

        jCheckBox1.setText("Chain To");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelSyncTo.add(jCheckBox1, gridBagConstraints);

        jButtonImport.setText("Import CC");
        jButtonImport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelSyncTo.add(jButtonImport, gridBagConstraints);

        jButtonExport.setText("Export CC");
        jButtonExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelSyncTo.add(jButtonExport, gridBagConstraints);

        jSplitPane1.setRightComponent(jPanelSyncTo);

        add(jSplitPane1);
    }// </editor-fold>//GEN-END:initComponents
        
    private void jComboBoxChainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxChainActionPerformed
        Integer sel = (Integer)((MXWrap)jComboBoxChain.getSelectedItem()).value;
        int x = -1;
        if (sel != null) {
            x = sel;
        }
        _process._data._patchToMixer = x;
    }//GEN-LAST:event_jComboBoxChainActionPerformed

    private void jCheckBoxSyncTogetherActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSyncTogetherActionPerformed
        _process._data._patchTogether = jCheckBoxSyncTogether.isSelected();
    }//GEN-LAST:event_jCheckBoxSyncTogetherActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        _process._parent.enterEditMode(true);
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jLabelKeyTrackerKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jLabelKeyTrackerKeyPressed
        switch(evt.getKeyCode()) {
            case 38: //UP
            case 40: //DOWN
            case 37: //LEFT
            case 39: //RIGHT
            case '\n':
            case ' ':
            case '\b':
                _process._parent.goNextFocus(_process._port, evt.getKeyCode());
                break;
        }
        
    }//GEN-LAST:event_jLabelKeyTrackerKeyPressed

    private void jLabelKeyTrackerFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jLabelKeyTrackerFocusGained
        if (_focusGroup.getFocus() == null) {
            _process._parent.goNextFocus(_process._port, 0);
        }
        jLabelKeyTracker.setForeground(Color.red);
    }//GEN-LAST:event_jLabelKeyTrackerFocusGained

    private void jLabelKeyTrackerFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jLabelKeyTrackerFocusLost
        jLabelKeyTracker.setForeground(jLabelKeyTracker.getBackground());
    }//GEN-LAST:event_jLabelKeyTrackerFocusLost

    private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
        jLabelKeyTracker.requestFocusInWindow();
    }//GEN-LAST:event_formFocusGained

    private void jButtonExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonExportActionPerformed
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            MXSetting setting = new MXSetting(file, false);
            setting.setTarget(_process);
            setting.writeToFile();
            JOptionPane.showMessageDialog(this, "MIXRecipe exported" + file);
        }
    }//GEN-LAST:event_jButtonExportActionPerformed

    private void jButtonImportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonImportActionPerformed
        MXFileOpenChooser chooser = new MXFileOpenChooser();
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            MXSetting setting = new MXSetting(file, false);
            setting.setTarget(_process);
            setting.readFile();   
            JOptionPane.showMessageDialog(this, "MIXRecipe imported " + file);
        }
    }//GEN-LAST:event_jButtonImportActionPerformed
    
    public JPanel getControllerCase() {
        return jPanelControllers;
    }

    public void initPagePanel() {
        MX32PageData data = _process._data;

        try {
            _focusGroup = new MXFocusGroup();

            data.setEveryComponents(null, null, null);

            JPanel panel001 = getControllerCase();

            java.awt.GridBagConstraints gbc;
            panel001.removeAll();
            panel001.setLayout(new GridBagLayout());

            int grindY = 0;

            ArrayList<MGCircle>[] matrixCircle = new ArrayList[4];

            for (int row = 0; row < MXStatic.CIRCLE_ROW_COUNT; ++ row) {
                ArrayList<MGCircle> newCircle = new ArrayList<MGCircle>();
                for (int col = 0; col < MXStatic.SLIDER_COLUMN_COUNT; col ++) {
                    MGCircle cc1 = new MGCircle(_process, row, col);

                    cc1.setSize(50, 50);
                    _focusGroup.attach(cc1);

                    gbc = new java.awt.GridBagConstraints();
                    gbc.gridx = col;
                    gbc.gridy = grindY;
                    gbc.fill = java.awt.GridBagConstraints.BOTH;
                    gbc.anchor = java.awt.GridBagConstraints.CENTER;
                    gbc.weightx = 0;
                    gbc.weighty = 0;

                    panel001.add(cc1, gbc);
                    newCircle.add(cc1);
                }
                matrixCircle[row] = newCircle;
                grindY ++;
            }


            ArrayList<MGSlider>[] matrixSlider = new ArrayList[1];

            for (int row = 0; row < MXStatic.SLIDER_ROW_COUNT; ++ row) {
                ArrayList<MGSlider> newSlider = new ArrayList<MGSlider>();
                matrixSlider[row] = newSlider;
                
                for (int col = 0; col < MXStatic.SLIDER_COLUMN_COUNT; ++col) {
                    MGSlider sc1 = new MGSlider(_process, row, col);
                    _focusGroup.attach(sc1);

                    sc1.setSize(50, 100);

                    gbc = new java.awt.GridBagConstraints();
                    gbc.gridx = col;
                    gbc.gridy = grindY;
                    gbc.fill = java.awt.GridBagConstraints.BOTH;
                    gbc.anchor = java.awt.GridBagConstraints.CENTER;
                    gbc.weightx = 1.0;
                    gbc.weighty = 1.0;

                    panel001.add(sc1, gbc);
                    newSlider.add(sc1);
                }
            }
            grindY++;

            ArrayList<MGDrum>[] matrixPad = new ArrayList[2];

            for (int row = 0; row < MXStatic.DRUM_ROW_COUNT; ++ row) {
                ArrayList<MGDrum> newPad = new ArrayList<MGDrum>();
                for (int col = 0; col < MXStatic.SLIDER_COLUMN_COUNT; ++col) {
                    MXUIValue number = data.getDrumStatus(row, col);
                    MGDrum rc1 = new MGDrum(_process, row, col);
                    //rc1.initUIWithStatus(number);

                   _focusGroup.attach(rc1);

                    newPad.add(rc1);
                    rc1.setSize(50, 50);

                    gbc = new java.awt.GridBagConstraints();
                    gbc.gridx = col;
                    gbc.gridy = grindY;
                    gbc.fill = java.awt.GridBagConstraints.BOTH;
                    gbc.anchor = java.awt.GridBagConstraints.CENTER;
                    gbc.weightx = 1.0;
                    gbc.weighty = 0;

                    panel001.add(rc1, gbc);
                }
                matrixPad[row] = newPad;
                grindY++;
            }
            _focusGroup.setFocusEnabled(true);

            int x = chainModel.indexOfValue(data._patchToMixer);
            jComboBoxChain.setSelectedIndex(x);

            data.setEveryComponents(matrixSlider, matrixCircle, matrixPad);

            jCheckBoxSyncTogether.setSelected(data._patchTogether);
        }finally {
            //data._underInit = false;
            updateUI();
        }
    }

    public void setFocusString(String str) {
        ArrayList<String> list = new ArrayList();
        MXUtil.split(str, list, '\n');
        DefaultListModel model = new DefaultListModel();
        for (String line : list) {
            model.addElement(line);
        }
        jListABC.setModel(model);
        jLabelKeyTracker.requestFocus();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButtonExport;
    private javax.swing.JButton jButtonImport;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JCheckBox jCheckBoxSyncTogether;
    private javax.swing.JComboBox<String> jComboBoxChain;
    private javax.swing.JLabel jLabelKeyTracker;
    private javax.swing.JList<String> jListABC;
    private javax.swing.JPanel jPanelControllers;
    private javax.swing.JPanel jPanelEdit;
    private javax.swing.JPanel jPanelSyncTo;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSplitPane jSplitPane1;
    // End of variables declaration//GEN-END:variables
}
