/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx30controller.ui;
import java.awt.Color;
import java.awt.SystemColor;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;
import jp.synthtarou.midimixer.mx30controller.MX32PageProcess;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MGDrum extends javax.swing.JPanel implements MXFocusAble {
    private static final MXDebugConsole _debug = new MXDebugConsole(MGDrum.class);
    final MX32PageProcess _process;
    final int _row;
    final int _column;

    public MGDrum(MX32PageProcess process, int row, int col) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
        _process = process;
        _row = row;
        _column = col;
        initComponents();

        updateUI();
    }
    
    public void updateUI() {
        super.updateUI();
        if (_process != null && _process._data != null) {
            MXUIValue status = _process._data.getDrumStatus(_row, _column);
            jLabel1.setText(status._name);
            focusStatusChanged(false);
        }
    }

    public void onMouseButtonHit(boolean button) {
        MXUIValue status = _process._data.getCircleStatus(_row, _column);
        
        boolean realValue = status._drumCurrentPushing;
        if (button) {
            if (status._drumIsToggleSwitch) {
                realValue = ! realValue;
            }else {
                realValue = true;
            }
        }else {
            if (status._drumIsToggleSwitch) {
            }else {
                realValue = false;
            }
        }
        jRadioButton1.setSelected(realValue);
        
        _process._data.updatePadView(_row, _column, realValue, status._uiValueMaximum, false);
    }
    
    public void setBackground(Color col) {
        super.setBackground(col);
        if (jLabel1 != null) {
            jLabel1.setBackground(col);
        }
        if (jRadioButton1 != null) {
            jRadioButton1.setBackground(col);
        }
    }

    public void setDefaultBackground() {
        int block = _column / 4;
        boolean toggle = (block % 2 == 0) ? true : false;
        if (toggle) {
            setBackground(MXStatic.colorSlider1);
        }else {
            setBackground(MXStatic.colorSlider2);
        }
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jRadioButton1 = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        jRadioButton1.setFocusable(false);
        jRadioButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jRadioButton1MousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jRadioButton1MouseReleased(evt);
            }
        });
        add(jRadioButton1, new java.awt.GridBagConstraints());

        jLabel1.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        add(jLabel1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jRadioButton1MousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRadioButton1MousePressed
        if (MXStatic._trapMouseForOnlySelect) {
            return;
        }
        if (_process._parent._editingControl) {
            //_process._parent.enterEditMode(false);
            //focusStatusChanged(false);
            //editContoller();
        }else if (jRadioButton1.isEnabled()) {
            onMouseButtonHit(true);
        }
    }//GEN-LAST:event_jRadioButton1MousePressed

    private void jRadioButton1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRadioButton1MouseReleased
        if (MXStatic._trapMouseForOnlySelect) {
            return;
        }

        MXUIValue status = _process._data.getCircleStatus(_row, _column);

        if (status._drumIsToggleSwitch) {
            return;
        }
        onMouseButtonHit(false);
    }//GEN-LAST:event_jRadioButton1MouseReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JRadioButton jRadioButton1;
    // End of variables declaration//GEN-END:variables

    @Override
    public void focusStatusChanged(boolean flag) {
        if (flag) {
            if (_process != null) {
                _process._parent.updateFocusInformation(MXUIValue.TYPE_DRUM, _process._port, _row, _column);
            }
        }else {
            setDefaultBackground();
        }
    }
    
    
    public void setValueChangeable(boolean using) {
        jRadioButton1.setEnabled(using);
    }
    
    @Override
    public void focusedMousePressed() {
        if (_process._parent._editingControl) {
            _process._parent.enterEditMode(false);
            focusStatusChanged(false);
            editContoller();
         }
    }

    @Override
    public void focusChangingValue() {
        _process._parent.updateFocusInformation(MXUIValue.TYPE_DRUM, _process._port, _row, _column);
    }

    public void increment() {
        onMouseButtonHit(true);
    }
    
    public void decriment() { 
        onMouseButtonHit(false);
    }
    
   public void editContoller() {
        _process._parent.enterEditMode(false);
        MXUIValue status = _process._data.getDrumStatus(_row, _column);
        MXUIValueConfig config = new MXUIValueConfig(status);
        MXUtil.showAsDialog(this, config, "Edit " + ui.toString());
        if (config._okOption) {
            MXMessage message = MXMessageFactory.fromDtext(config._textAfter);
            message.setPort(_process._port);
            if (message.isMessageTypeChannel()) {
                message.setChannel(config._channelAfter);
            }
            if (message.hasGateField()) {
                message.setGate(config._gateAfter);
            }
            status.setMonitoring(message);
            status._name = config._nameAfter;
            jLabel1.setText(status._name);
        }
    }
}
