/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx60output;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.midi.port.FinalMIDIOut;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.mx20patchbay.MX20Process;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX60Process extends MXReceiver {
    private MX60View _view;
    private MX20Process _patchBay;
    public MX60Data _data;

    public MX60Process() {
        _data = new MX60Data();
        _patchBay = new MX20Process(false);
        _view = new MX60View(this);
        _view.setLogger(FinalMIDIOut.getInstance().getLogger());
    }
    
    public void readSettings() {
        _patchBay.readSettings();
    }

    public void setUseLogging(boolean log) {
        FinalMIDIOut.getInstance().getLogger().setUsingThis(log);
    }
    
    public boolean isUseLogging() {
        if (FinalMIDIOut.getInstance().getLogger() != null) {
            return FinalMIDIOut.getInstance().getLogger().usingThis();
        }
        return true;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (usingThis()) {
            if (_data.isMessageToSkip(message)) {
                return;
            }
        }
        _patchBay.setNextReceiver(getNextReceiver());
        _patchBay.processMXMessage(message);
    }
    

    @Override
    public String getReceiverName() {
        return "Output Dispatcher";
    }

    @Override
    public JComponent getReceiverView() {
        return _view;
    }
    
    public MX20Process getPatchBay() {
        return _patchBay;
    }
}
