package info.projectkyoto.mms.assetmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.net.Uri;
import android.os.Environment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

import static info.projectkyoto.mms.assetmanager.common.MMSConfigBaseColumns.*;
/**
 *
 * @author kobayasi
 */
public class ConfigDBHelper extends SQLiteOpenHelper{
    public static final int DB_VERSION = 1;
    final Context context;
    final byte[] buf = new byte[1024 * 16];
    private static final Logger logger = Logger.getLogger(ConfigDBHelper.class.getName());
    public ConfigDBHelper(Context context) {
        super(context, ((MMSApplication)context.getApplicationContext()).getConfigDBFile().getAbsolutePath(), null, DB_VERSION);
        this.context = context;
    }
    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE "+TABLE_NAME+" ("
                    + _ID+"  INTEGER PRIMARY KEY AUTOINCREMENT,"
                    + CONFIG_TYPE+" TEXT,"
                    + CONFIG_NAME+" TEXT,"
                    + DESCRIPTION+" TEXT,"
                    + CONFIG_DATA+" TEXT"
                    + ");");
        db.execSQL("CREATE UNIQUE INDEX idx_mmsconfig_name on mmsconfig(config_name);");
//        db.execSQL("INSERT INTO "+TABLE_NAME+"("+
//                CONFIG_TYPE
//                +","+CONFIG_NAME
//                +","+DESCRIPTION
//                +","+CONFIG_DATA
//                +") VALUES('PLAYER1','conf1','設定１','data');");
//        db.execSQL("INSERT INTO "+TABLE_NAME+"("+
//                CONFIG_TYPE
//                +","+CONFIG_NAME
//                +","+DESCRIPTION
//                +","+CONFIG_DATA
//                +") VALUES('PLAYER1','conf2','設定2','data');");
//        db.execSQL("INSERT INTO "+TABLE_NAME+"("+
//                CONFIG_TYPE
//                +","+CONFIG_NAME
//                +","+DESCRIPTION
//                +","+CONFIG_DATA
//                +") VALUES('PLAYER3','conf3','設定3','data');");
    }

    @Override
    public void onOpen(SQLiteDatabase db) {
        if (!Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            throw new IllegalStateException("sdcard is not mounted.");
        }
        ((MMSApplication)context.getApplicationContext()).getConfigDBFile();
        super.onOpen(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        logger.info("Upgrade "+oldVersion+" to "+newVersion);
//        db.execSQL("DROP TABLE zipEntry;");
//        db.execSQL("DROP TABLE archive;");
//        onCreate(db);
    }
    public boolean checkCondition() {
        try {
            SQLiteDatabase db = getReadableDatabase();
            db.execSQL("SELECT _id FROM archive WHERE _id = -1");
            return true;
        } catch(Exception ex) {
            logger.log(Level.WARNING,"checkCondition:false",ex);
        }
        return false;
    }
}
