/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.widget.Toast;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author kobayasi
 */
public class MMSContentProvider extends ContentProvider {

    Logger logger = Logger.getLogger(MMSContentProvider.class.getName());
    public File contentDir;

    @Override
    public boolean onCreate() {
        contentDir = new File(Environment.getExternalStorageDirectory(), "info.projectkyoto.mms/local");
        return true;
    }

    @Override
    public Cursor query(Uri arg0, String[] arg1, String arg2, String[] arg3, String arg4) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getType(Uri uri) {
        return null;
    }

    @Override
    public Uri insert(Uri uri, ContentValues initialValues) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int delete(Uri uri, String where, String[] whereArgs) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int update(Uri uri, ContentValues values, String where, String[] whereArgs) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        checkCondition();
        List<String> pathSegments = uri.getPathSegments();
        if (pathSegments.size() < 3) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        } else if (pathSegments.get(0).equals("contents")) {
            try {
                String archiveName = URLDecoder.decode(pathSegments.get(1));
                int len = 1 + pathSegments.get(0).length()+1 + pathSegments.get(1).length() + 1;
                logger.info("uri.getPath() = "+uri.getPath()+" "+pathSegments.get(0));
                String entryName = uri.getPath().substring(len);
                File archiveDir = new File(contentDir, archiveName);
                File entryFile = new File(archiveDir, entryName);
                logger.info("entryFile = "+entryFile.getCanonicalPath()+ " contentDir = "+contentDir.getCanonicalPath());
                if (!entryFile.getCanonicalPath().startsWith(contentDir.getCanonicalPath())) {
                    throw new IllegalArgumentException("Unknown URI " + uri);
                }
                ParcelFileDescriptor pfd = FileUtil.openFile(entryFile);
                return pfd;
            } catch (IOException ex) {
                Logger.getLogger(MMSContentProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }

    private void checkCondition() {
        if (!Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            throw new IllegalStateException("sdcard is not mounted.");
        }
    }
}
