/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.DefaultAnimatorImpl;
import java.util.ArrayList;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;

public abstract class AnimatorBase
implements GLAnimatorControl {
    protected static final boolean DEBUG = Debug.debug("Animator");
    private static int animatorCount = 0;
    protected ArrayList drawables = new ArrayList();
    protected boolean drawablesEmpty;
    protected AnimatorImpl impl;
    protected String baseName;
    protected Thread animThread;
    protected boolean ignoreExceptions;
    protected boolean printExceptions;
    protected long startTime;
    protected long curTime;
    protected int totalFrames;
    protected RecursiveLock stateSync = new RecursiveLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimatorBase() {
        if (GLProfile.isAWTAvailable()) {
            try {
                this.impl = (AnimatorImpl)Class.forName("com.jogamp.opengl.util.AWTAnimatorImpl").newInstance();
                this.baseName = "AWTAnimator";
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (null == this.impl) {
            this.impl = new DefaultAnimatorImpl();
            this.baseName = "Animator";
        }
        Class<Animator> clazz = Animator.class;
        synchronized (Animator.class) {
            this.baseName = this.baseName.concat("-" + ++animatorCount);
            this.drawablesEmpty = true;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            this.resetCounter();
            return;
        }
    }

    protected abstract String getBaseName(String var1);

    public synchronized void add(GLAutoDrawable gLAutoDrawable) {
        if (DEBUG) {
            System.err.println("Animator add: " + gLAutoDrawable.hashCode() + " - " + Thread.currentThread());
        }
        boolean bl = this.pause();
        this.drawables.add(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(this);
        if (bl) {
            this.resume();
        }
        if (!this.impl.skipWaitForCompletion(this.animThread)) {
            while (this.isStarted() && !this.isPaused() && !this.isAnimating()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.notifyAll();
    }

    @Override
    public synchronized void remove(GLAutoDrawable gLAutoDrawable) {
        if (DEBUG) {
            System.err.println("Animator remove: " + gLAutoDrawable.hashCode() + " - " + Thread.currentThread());
        }
        boolean bl = this.pause();
        this.drawables.remove(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(null);
        if (bl) {
            this.resume();
        }
        if (!this.impl.skipWaitForCompletion(this.animThread)) {
            while (this.isStarted() && this.drawablesEmpty && this.isAnimating()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.notifyAll();
    }

    protected void display() {
        this.impl.display(this.drawables, this.ignoreExceptions, this.printExceptions);
        this.curTime = System.currentTimeMillis();
        ++this.totalFrames;
    }

    @Override
    public long getCurrentTime() {
        return this.curTime;
    }

    @Override
    public long getDuration() {
        return this.curTime - this.startTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getTotalFrames() {
        return this.totalFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getThread() {
        this.stateSync.lock();
        try {
            Thread thread = this.animThread;
            return thread;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    @Override
    public synchronized void resetCounter() {
        this.curTime = this.startTime = System.currentTimeMillis();
        this.totalFrames = 0;
    }

    public void setIgnoreExceptions(boolean bl) {
        this.ignoreExceptions = bl;
    }

    public void setPrintExceptions(boolean bl) {
        this.printExceptions = bl;
    }

    public String toString() {
        return this.getClass().getName() + "[started " + this.isStarted() + ", animating " + this.isAnimating() + ", paused " + this.isPaused() + ", frames " + this.getTotalFrames() + ", drawable " + this.drawables.size() + "]";
    }

    public static interface AnimatorImpl {
        public void display(ArrayList var1, boolean var2, boolean var3);

        public boolean skipWaitForCompletion(Thread var1);
    }
}

