/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonWire;
import com.jme3.scene.shape.Box;
import com.jme3.shader.VarType;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import projectkyoto.jme3.mmd.PMDGeometry;
import projectkyoto.jme3.mmd.PMDMesh;
import projectkyoto.jme3.mmd.PMDSkinMesh;
import projectkyoto.jme3.mmd.RigidBodyConverter;
import projectkyoto.jme3.mmd.Skin;
import projectkyoto.jme3.mmd.nativelib.SkinUtil;
import projectkyoto.mmd.file.PMDBone;
import projectkyoto.mmd.file.PMDException;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.SavableUtil;

public class PMDNode
extends Node {
    PMDModel pmdModel;
    Skeleton skeleton;
    PMDMesh[] targets;
    PMDSkinMesh[] skinTargets;
    PMDGeometry[] pmdGeometryArray;
    Map<String, Skin> skinMap = new HashMap<String, Skin>();
    Skin[] skinArray = new Skin[0];
    FloatBuffer skinPosBuffer;
    AssetManager assetManager;
    Matrix4f[] offsetMatrices;
    FloatBuffer offsetMatrixbuffer;
    boolean updateNeeded = true;
    boolean skinUpdateNeeded = true;
    boolean wireFrame = false;
    float edgeSize = 1.0f;
    boolean skeletonWireVisible = false;
    Geometry skeletonWireGeom;
    boolean bonePositionVisible = false;
    Node bonePositionNode;
    Geometry[] bonePositionGeomArray;
    Node rigidBodyNode;
    Node jointNode;
    boolean glslSkinning = true;
    private PMDNode original = null;
    boolean setBoneMatricesFlag = true;

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule c = e.getCapsule((Savable)this);
        this.pmdModel = (PMDModel)SavableUtil.read(c, "pmdModel", null);
        this.skeleton = (Skeleton)c.readSavable("skeleton", null);
        this.skinMap = c.readStringSavableMap("skinMap", new HashMap());
        this.edgeSize = c.readFloat("edgeSize", 1.0f);
        int pmdGeometryArrayLength = c.readInt("pmdGeometryArrayLength", 0);
        this.pmdGeometryArray = new PMDGeometry[pmdGeometryArrayLength];
        this.targets = new PMDMesh[pmdGeometryArrayLength];
        int skinTargetsLength = c.readInt("skinTargetsLength", 0);
        this.skinTargets = new PMDSkinMesh[skinTargetsLength];
        VertexBuffer skinvb = (VertexBuffer)c.readSavable("skinvb", null);
        VertexBuffer skinnb = (VertexBuffer)c.readSavable("skinnb", null);
        VertexBuffer skintb = (VertexBuffer)c.readSavable("skintb", null);
        VertexBuffer skinvb2 = skinvb.clone();
        VertexBuffer skinnb2 = skinnb.clone();
        int meshCount = 0;
        int skinMeshCount = 0;
        Iterator i$ = this.getChildren().iterator();
        while (i$.hasNext()) {
            Spatial sp;
            Spatial newSp = sp = (Spatial)i$.next();
            if (!(sp instanceof PMDGeometry)) continue;
            Mesh mesh = ((Geometry)newSp).getMesh();
            if (mesh instanceof PMDMesh) {
                PMDMesh pmdMesh = (PMDMesh)mesh;
                pmdMesh.setVbBackup(pmdMesh.getBuffer(VertexBuffer.Type.Position));
                pmdMesh.setNbBackup(pmdMesh.getBuffer(VertexBuffer.Type.Normal));
                this.pmdGeometryArray[meshCount] = (PMDGeometry)sp;
                this.targets[meshCount++] = (PMDMesh)mesh;
                continue;
            }
            if (!(mesh instanceof PMDSkinMesh)) continue;
            PMDSkinMesh skinMesh = (PMDSkinMesh)mesh;
            if (skinMeshCount != 0) {
                skinMesh.setBuffer(skinvb);
                skinMesh.setSkinvb2(skinvb2);
                skinMesh.setBuffer(skinnb);
                skinMesh.setBuffer(skintb);
            } else {
                skinMesh.setBuffer(skinvb);
                skinMesh.setSkinvb2(skinvb2);
                skinMesh.setBuffer(skinnb);
                skinMesh.setBuffer(skintb);
            }
            this.skinTargets[skinMeshCount++] = (PMDSkinMesh)mesh;
        }
        this.calcOffsetMatrices();
        Savable[] sa = c.readSavableArray("skinArray", (Savable[])new Skin[0]);
        this.skinArray = new Skin[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            Skin skin;
            this.skinArray[i] = skin = (Skin)sa[i];
            skin.pmdNode = this;
            for (int i2 = 0; i2 < this.pmdModel.getSkinCount() && !this.pmdModel.getSkinData()[i2].getSkinName().equals(skin.getSkinName()); ++i2) {
            }
            skin.setWeight(0.0f);
            skin.setUpdateNeeded(true);
            this.skinMap.put(skin.skinName, skin);
        }
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule c = e.getCapsule((Savable)this);
        c.write(1, "version", 1);
        SavableUtil.write(c, this.pmdModel, "pmdModel");
        c.write((Savable)this.skeleton, "skeleton", (Savable)new Skeleton());
        c.writeStringSavableMap(this.skinMap, "skinMap", new HashMap());
        c.write(this.edgeSize, "edgeSize", 1.0f);
        c.write(this.pmdGeometryArray.length, "pmdGeometryArrayLength", 0);
        c.write(this.skinTargets.length, "skinTargetsLength", 0);
        if (this.skinTargets != null && this.skinTargets.length > 0) {
            PMDSkinMesh mesh = this.skinTargets[0];
            c.write((Savable)mesh.getSkinvb2(), "skinvb", null);
            c.write((Savable)mesh.getBuffer(VertexBuffer.Type.TexCoord), "skintb", null);
        }
        c.write((Savable[])this.skinArray, "skinArray", null);
    }

    public PMDNode(String name, PMDModel pmdModel, AssetManager assetManager) {
        super(name);
        this.pmdModel = pmdModel;
        this.assetManager = assetManager;
    }

    public PMDNode() {
    }

    public void init() {
        this.initMaterials();
        this.resetToBind();
    }

    void setSkinData(PMDSkinMesh[] skinTargets, List<PMDVertex> skinVertexList, Skin[] skinAray) {
        this.skinTargets = skinTargets;
        for (Skin skin : skinAray) {
            this.skinMap.put(skin.getSkinName(), skin);
        }
    }

    public PMDModel getPmdModel() {
        return this.pmdModel;
    }

    public void setPmdModel(PMDModel pmdModel) {
        this.pmdModel = pmdModel;
    }

    public Matrix4f[] calcOffsetMatrices() {
        this.offsetMatrices = this.skeleton.computeSkinningMatrices();
        if (this.offsetMatrixbuffer == null) {
            this.offsetMatrixbuffer = BufferUtils.createFloatBuffer((int)(this.offsetMatrices.length * 16));
        }
        this.offsetMatrixbuffer.position(0);
        for (Matrix4f m : this.offsetMatrices) {
            m.fillFloatBuffer(this.offsetMatrixbuffer, true);
        }
        return this.offsetMatrices;
    }

    public void update() {
        this.updateNeeded = false;
        for (PMDGeometry g : this.pmdGeometryArray) {
            Material material = g.getMaterial();
            PMDMesh pmdMesh = (PMDMesh)g.getMesh();
            int[] boneIndexArray = pmdMesh.getBoneIndexArray();
            Matrix4f[] boneMatrixArray = pmdMesh.getBoneMatrixArray();
            if (!this.glslSkinning) continue;
            FloatBuffer fb = pmdMesh.getBoneMatrixBuffer();
            fb.position(0);
            SkinUtil.copyBoneMatrix((FloatBuffer)this.offsetMatrixbuffer, (FloatBuffer)fb, (ShortBuffer)pmdMesh.getBoneIndexBuffer());
            if (pmdMesh.boneMatricesParamIndex < 0) {
                material.setParam("BoneMatrices", VarType.Matrix4Array, (Object)pmdMesh.getBoneMatrixBuffer());
                pmdMesh.boneMatricesParamIndex = g.getMaterial().getParamIndex("BoneMatrices");
                continue;
            }
            material.setParam(pmdMesh.boneMatricesParamIndex, VarType.Matrix4Array, (Object)pmdMesh.getBoneMatrixBuffer());
        }
        FloatBuffer fb = null;
        for (int i = this.getChildren().size() - 1; i >= 0; --i) {
            Mesh mesh;
            PMDGeometry g;
            Spatial sp = this.getChild(i);
            if (!(sp instanceof PMDGeometry) || !((mesh = (g = (PMDGeometry)sp).getMesh()) instanceof PMDSkinMesh)) continue;
            PMDSkinMesh skinMesh = (PMDSkinMesh)mesh;
            Material m = g.getMaterial();
            int[] boneIndexArray = skinMesh.getBoneIndexArray();
            if (fb == null) {
                fb = skinMesh.getBoneMatrixBuffer();
                fb.position(0);
                SkinUtil.copyBoneMatrix((FloatBuffer)this.offsetMatrixbuffer, (FloatBuffer)fb, (ShortBuffer)skinMesh.getBoneIndexBuffer());
            }
            if (!this.glslSkinning) continue;
            if (skinMesh.boneMatricesParamIndex < 0) {
                m.setParam("BoneMatrices", VarType.Matrix4Array, (Object)fb);
                skinMesh.boneMatricesParamIndex = g.getMaterial().getParamIndex("BoneMatrices");
                continue;
            }
            m.setParam(skinMesh.boneMatricesParamIndex, VarType.Matrix4Array, (Object)fb);
        }
        if (!this.glslSkinning) {
            for (PMDMesh pMDMesh : this.targets) {
                this.softwareSkinUpdate(pMDMesh);
            }
        }
        this.swapSkinMesh();
        if (this.skeletonWireGeom != null) {
            ((SkeletonWire)this.skeletonWireGeom.getMesh()).updateGeometry();
        }
        if (this.bonePositionVisible) {
            for (int i = 0; i < this.bonePositionGeomArray.length; ++i) {
                Geometry bonePosGeom = this.bonePositionGeomArray[i];
                Bone bone = this.skeleton.getBone(i);
                Vector3f vector3f = bone.getModelSpacePosition();
                bonePosGeom.setLocalTranslation(vector3f);
            }
        }
    }

    private void swapSkinMesh() {
        if (this.skinTargets.length == 0) {
            return;
        }
        VertexBuffer vb = this.skinTargets[0].getBuffer(VertexBuffer.Type.Position);
        this.skinTargets[0].skinvb2.setUpdateNeeded();
        VertexBuffer skinvb2 = this.skinTargets[0].skinvb2;
        for (PMDSkinMesh skinMesh : this.skinTargets) {
            skinMesh.setBuffer(skinvb2);
        }
        this.skinTargets[0].skinvb2 = vb;
    }

    private void softwareSkinUpdate(PMDMesh mesh) {
        int maxWeightsPerVert = 2;
        int fourMinusMaxWeights = 4 - maxWeightsPerVert;
        this.resetToBind(mesh);
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        fvb.rewind();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        fnb.rewind();
        FloatBuffer fvb2 = (FloatBuffer)mesh.getVbBackup().getData();
        fvb2.rewind();
        FloatBuffer fnb2 = (FloatBuffer)mesh.getNbBackup().getData();
        fnb2.rewind();
        ShortBuffer ib = (ShortBuffer)mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
        FloatBuffer wb = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        ib.rewind();
        wb.rewind();
        int idxWeights = 0;
        TempVars vars = TempVars.get();
        float[] posBuf = vars.skinPositions;
        float[] normBuf = vars.skinNormals;
        int iterations = (int)FastMath.ceil((float)((float)fvb.capacity() / (float)posBuf.length));
        int bufLength = posBuf.length * 3;
        for (int i = iterations - 1; i >= 0; --i) {
            bufLength = Math.min(posBuf.length, fvb.remaining());
            fvb2.get(posBuf, 0, bufLength);
            fnb2.get(normBuf, 0, bufLength);
            int verts = bufLength / 3;
            int idxPositions = 0;
            for (int vert = verts - 1; vert >= 0; --vert) {
                float nmx = normBuf[idxPositions];
                float vtx = posBuf[idxPositions++];
                float nmy = normBuf[idxPositions];
                float vty = posBuf[idxPositions++];
                float nmz = normBuf[idxPositions];
                float vtz = posBuf[idxPositions++];
                float rx = 0.0f;
                float ry = 0.0f;
                float rz = 0.0f;
                float rnx = 0.0f;
                float rny = 0.0f;
                float rnz = 0.0f;
                for (int w = maxWeightsPerVert - 1; w >= 0; --w) {
                    float weight = wb.get(idxWeights);
                    Matrix4f mat = mesh.getBoneMatrixArray()[ib.get(idxWeights++)];
                    rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                    ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                    rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                    rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                    rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                    rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
                }
                idxWeights += fourMinusMaxWeights;
                normBuf[idxPositions -= 3] = rnx;
                posBuf[idxPositions++] = rx;
                normBuf[idxPositions] = rny;
                posBuf[idxPositions++] = ry;
                normBuf[idxPositions] = rnz;
                posBuf[idxPositions++] = rz;
            }
            fvb.put(posBuf, 0, bufLength);
            fnb.put(normBuf, 0, bufLength);
        }
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
        vars.release();
    }

    public void updateSkinBackData() {
        if (this.skinTargets.length == 0) {
            return;
        }
        PMDSkinMesh skinMesh = this.skinTargets[0];
        VertexBuffer vb = skinMesh.getSkinvb2();
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        fvb.position(0);
        int length = fvb.capacity();
        SkinUtil.copy((Buffer)this.skinPosBuffer, (Buffer)fvb, (int)(fvb.limit() * 4));
        for (Skin skin : this.skinArray) {
            float weight = skin.getWeight();
            if (weight != 0.0f) {
                SkinUtil.setSkin((FloatBuffer)fvb, (ShortBuffer)skin.getIndexBuf(), (FloatBuffer)skin.getSkinBuf(), (float)weight);
            }
            skin.setUpdateNeeded(false);
        }
        vb.setUpdateNeeded();
        this.skinUpdateNeeded = false;
    }

    /*
     * WARNING - void declaration
     */
    public void resetToBind() {
        void var1_2;
        boolean bl = false;
        while (var1_2 < this.skeleton.getBoneCount()) {
            Bone bone = this.skeleton.getBone((int)var1_2);
            PMDBone pmdBone = this.pmdModel.getBoneList().getBones()[var1_2];
            if (pmdBone.getParentBoneIndex() < this.skeleton.getBoneCount()) {
                Bone bone2 = this.skeleton.getBone(pmdBone.getParentBoneIndex());
                PMDBone parentPMDBone = this.pmdModel.getBoneList().getBones()[pmdBone.getParentBoneIndex()];
                Vector3f v1 = new Vector3f();
                Vector3f v2 = new Vector3f();
                v1.set(pmdBone.getBoneHeadPos().x, pmdBone.getBoneHeadPos().y, pmdBone.getBoneHeadPos().z);
                v2.set(parentPMDBone.getBoneHeadPos().x, parentPMDBone.getBoneHeadPos().y, parentPMDBone.getBoneHeadPos().z);
                v1.subtractLocal(v2);
                bone.setBindTransforms(v1, Quaternion.IDENTITY, new Vector3f(1.0f, 1.0f, 1.0f));
            } else {
                Vector3f vector3f = new Vector3f();
                vector3f.set(pmdBone.getBoneHeadPos().x, pmdBone.getBoneHeadPos().y, pmdBone.getBoneHeadPos().z);
                bone.setBindTransforms(vector3f, Quaternion.IDENTITY, new Vector3f(1.0f, 1.0f, 1.0f));
            }
            ++var1_2;
        }
        for (PMDMesh pMDMesh : this.targets) {
            this.resetToBind(pMDMesh);
        }
        for (Skin skin : this.skinArray) {
            skin.setWeight(0.0f);
        }
        this.setUpdateNeeded(true);
    }

    void resetToBind(PMDMesh mesh) {
    }

    void _resetToBind(PMDMesh mesh) {
        int i;
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer vfb = (FloatBuffer)vb.getData();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer nfb = (FloatBuffer)nb.getData();
        VertexBuffer bvb = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        FloatBuffer bvfb = (FloatBuffer)bvb.getData();
        VertexBuffer bnb = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
        FloatBuffer bnfb = (FloatBuffer)bnb.getData();
        for (i = 0; i < vfb.capacity(); ++i) {
            vfb.put(i, bvfb.get(i));
        }
        for (i = 0; i < nfb.capacity(); ++i) {
            nfb.put(i, bnfb.get(i));
        }
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
    }

    void resetToBindSkinBackData(PMDSkinMesh mesh) {
        VertexBuffer vb = mesh.getSkinvb2();
        FloatBuffer vfb = (FloatBuffer)vb.getData();
        VertexBuffer bvb = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        FloatBuffer bvfb = (FloatBuffer)bvb.getData();
        VertexBuffer bnb = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
        FloatBuffer bnfb = (FloatBuffer)bnb.getData();
        for (int i = 0; i < vfb.capacity(); ++i) {
            vfb.put(i, bvfb.get(i));
        }
        vb.setUpdateNeeded();
    }

    public Set<String> getSkinSet() {
        return this.skinMap.keySet();
    }

    public Map<String, Skin> getSkinMap() {
        return this.skinMap;
    }

    public float getSkinWeight(String skinName) {
        return this.skinMap.get(skinName).getWeight();
    }

    public void setSkinWeight(String skinName, float weight) {
        Skin skin = this.skinMap.get(skinName);
        if (skin != null) {
            skin.setWeight(weight);
            this.skinUpdateNeeded = true;
        }
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public void setUpdateNeeded(boolean updateNeeded) {
        this.updateNeeded = updateNeeded;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public void setWireFrame(boolean wireFrame) {
        for (Spatial sp : this.getChildren()) {
            if (!(sp instanceof Geometry)) continue;
            Geometry geom = (Geometry)sp;
            geom.getMaterial().getAdditionalRenderState().setWireframe(wireFrame);
        }
        this.wireFrame = wireFrame;
    }

    public boolean isWireFrame() {
        return this.wireFrame;
    }

    public void setEdgeWidth(float edgeSize) {
        for (Spatial sp : this.getChildren()) {
            PMDGeometry geom;
            if (!(sp instanceof PMDGeometry) || (geom = (PMDGeometry)sp).getPmdMaterial().getEdgeFlag() == 0) continue;
            geom.getMaterial().setFloat("EdgeSize", edgeSize);
        }
        this.edgeSize = edgeSize;
    }

    public void setSkeletonWireVisible(boolean skeletonWireVisible) {
        if (skeletonWireVisible) {
            if (this.skeletonWireGeom == null) {
                SkeletonWire skeletonWire = new SkeletonWire(this.skeleton);
                this.skeletonWireGeom = new Geometry("skeletonWire", (Mesh)skeletonWire);
                Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat.setColor("Color", ColorRGBA.Green);
                mat.getAdditionalRenderState().setDepthTest(false);
                mat.getAdditionalRenderState().setDepthWrite(false);
                this.skeletonWireGeom.setMaterial(mat);
                this.skeletonWireGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
                this.attachChild((Spatial)this.skeletonWireGeom);
                skeletonWire.updateGeometry();
            }
        } else if (this.skeletonWireGeom != null) {
            this.skeletonWireGeom.removeFromParent();
            this.skeletonWireGeom = null;
        }
        this.skeletonWireVisible = skeletonWireVisible;
    }

    public void setBonePositionVisible(boolean bonePositionVisible) {
        if (bonePositionVisible) {
            if (this.bonePositionNode == null) {
                this.bonePositionNode = new Node("bonePositionNode");
                this.bonePositionGeomArray = new Geometry[this.pmdModel.getBoneList().getBoneCount()];
                Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat.setColor("Color", ColorRGBA.Red);
                mat.getAdditionalRenderState().setDepthTest(false);
                mat.getAdditionalRenderState().setDepthWrite(false);
                Material mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat2.setColor("Color", ColorRGBA.Blue);
                mat2.getAdditionalRenderState().setDepthTest(false);
                mat2.getAdditionalRenderState().setDepthWrite(false);
                Material mat3 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat3.setColor("Color", ColorRGBA.Green);
                mat3.getAdditionalRenderState().setDepthTest(false);
                mat3.getAdditionalRenderState().setDepthWrite(false);
                for (int i = 0; i < this.bonePositionGeomArray.length; ++i) {
                    Mesh mesh = new Mesh();
                    Geometry geom = new Geometry(this.pmdModel.getBoneList().getBones()[i].getBoneName(), (Mesh)new Box(0.1f, 0.1f, 0.0f));
                    geom.setMaterial(mat);
                    geom.setQueueBucket(RenderQueue.Bucket.Transparent);
                    this.bonePositionGeomArray[i] = geom;
                    this.bonePositionNode.attachChild((Spatial)geom);
                    geom.addControl((Control)new BillboardControl());
                    if (this.pmdModel.getBoneList().getBones()[i].getBoneType() == 2) {
                        geom.setMaterial(mat2);
                    }
                    if (this.pmdModel.getBoneList().getBones()[i].getBoneType() != 6) continue;
                    geom.setMaterial(mat3);
                }
                this.attachChild((Spatial)this.bonePositionNode);
            }
        } else if (this.bonePositionNode != null) {
            this.bonePositionNode.removeFromParent();
            this.bonePositionNode = null;
            this.bonePositionGeomArray = null;
        }
        this.setUpdateNeeded(true);
        this.bonePositionVisible = bonePositionVisible;
    }

    public Node getBonePositionNode() {
        return this.bonePositionNode;
    }

    public Matrix4f[] getOffsetMatrices() {
        return this.offsetMatrices;
    }

    public void setRigidBodyVisible(boolean flag) {
        if (flag) {
            if (this.rigidBodyNode != null) {
                return;
            }
            RigidBodyConverter rbc = new RigidBodyConverter(this.pmdModel, this.assetManager);
            this.rigidBodyNode = rbc.convert("rigidBody");
            this.attachChild((Spatial)this.rigidBodyNode);
        } else if (this.rigidBodyNode != null) {
            this.detachChild((Spatial)this.rigidBodyNode);
            this.rigidBodyNode = null;
        }
    }

    public Node getRigidBodyNode() {
        return this.rigidBodyNode;
    }

    void initMaterials() {
        for (Spatial sp : this.getChildren()) {
            PMDGeometry geom;
            Mesh mesh;
            if (!(sp instanceof PMDGeometry) || !((mesh = (geom = (PMDGeometry)sp).getMesh()) instanceof PMDMesh)) continue;
            if (this.glslSkinning) {
                geom.setMaterial(geom.getGlslSkinningMaterial());
                continue;
            }
            geom.setMaterial(geom.getNoSkinningMaterial());
        }
    }

    public Node getJointNode() {
        return this.jointNode;
    }

    public void setJointNode(Node jointNode) {
        this.jointNode = jointNode;
    }

    public boolean isGlslSkinning() {
        return this.glslSkinning;
    }

    public void setGlslSkinning(boolean glslSkinning) {
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.pmdModel.getModelName().hashCode();
    }

    public PMDNode clone() {
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "clone PMDNode " + this.pmdModel.getModelName());
        try {
            PMDNode newPMDNode = (PMDNode)super.clone();
            newPMDNode.skeleton = new Skeleton(this.skeleton);
            for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
                Bone newBone = newPMDNode.skeleton.getBone(i);
                Bone bone = this.skeleton.getBone(i);
                newBone.getLocalPosition().set(bone.getLocalPosition());
                newBone.getLocalRotation().set(bone.getLocalRotation());
                newBone.getLocalScale().set(bone.getLocalScale());
            }
            newPMDNode.pmdGeometryArray = new PMDGeometry[this.pmdGeometryArray.length];
            newPMDNode.targets = new PMDMesh[this.targets.length];
            newPMDNode.skinTargets = new PMDSkinMesh[this.skinTargets.length];
            int meshCount = 0;
            int skinMeshCount = 0;
            Iterator<Object> i$ = newPMDNode.getChildren().iterator();
            while (i$.hasNext()) {
                PMDSkinMesh skinMesh0;
                PMDSkinMesh skinMesh;
                Spatial sp;
                Spatial newSp = sp = (Spatial)i$.next();
                if (!(sp instanceof PMDGeometry)) continue;
                Mesh mesh = ((Geometry)newSp).getMesh();
                if (mesh instanceof PMDMesh) {
                    newPMDNode.pmdGeometryArray[meshCount] = (PMDGeometry)sp;
                    newPMDNode.targets[meshCount++] = (PMDMesh)mesh;
                    continue;
                }
                if (!(mesh instanceof PMDSkinMesh)) continue;
                mesh.setMode(Mesh.Mode.Triangles);
                if (skinMeshCount != 0) {
                    skinMesh = (PMDSkinMesh)mesh;
                    skinMesh0 = newPMDNode.skinTargets[0];
                    skinMesh.setBuffer(skinMesh0.getBuffer(VertexBuffer.Type.Position));
                    skinMesh.setSkinvb2(skinMesh0.getSkinvb2());
                    skinMesh.setBuffer(skinMesh0.getBuffer(VertexBuffer.Type.Normal));
                    if (skinMesh0.getBuffer(VertexBuffer.Type.TexCoord) != null) {
                        skinMesh.setBuffer(skinMesh0.getBuffer(VertexBuffer.Type.TexCoord));
                    }
                } else {
                    skinMesh = (PMDSkinMesh)mesh;
                    skinMesh0 = this.skinTargets[0];
                    skinMesh.setBuffer(skinMesh0.getBuffer(VertexBuffer.Type.Position).clone());
                    skinMesh.setSkinvb2(skinMesh0.getSkinvb2().clone());
                    skinMesh.setBuffer(skinMesh0.getBuffer(VertexBuffer.Type.Normal));
                    if (skinMesh0.getBuffer(VertexBuffer.Type.TexCoord) != null) {
                        skinMesh.setBuffer(skinMesh0.getBuffer(VertexBuffer.Type.TexCoord));
                    }
                }
                newPMDNode.skinTargets[skinMeshCount++] = (PMDSkinMesh)mesh;
            }
            newPMDNode.skinMap = new HashMap<String, Skin>();
            for (String skinName : this.skinMap.keySet()) {
                Skin skin = this.skinMap.get(skinName);
                skin = skin.clone();
                skin.pmdNode = newPMDNode;
                newPMDNode.skinMap.put(skinName, skin);
            }
            newPMDNode.skinArray = newPMDNode.skinMap.values().toArray(new Skin[newPMDNode.skinMap.size()]);
            newPMDNode.skeleton.updateWorldVectors();
            newPMDNode.offsetMatrixbuffer = null;
            newPMDNode.calcOffsetMatrices();
            newPMDNode.updateSkinBackData();
            newPMDNode.update();
            newPMDNode.updateSkinBackData();
            newPMDNode.update();
            newPMDNode.original = this.original != null ? this.original : this;
            return newPMDNode;
        }
        catch (CloneNotSupportedException ex) {
            throw new PMDException(ex);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.pmdModel != null) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "finalize PMDNode " + this.pmdModel.getModelName());
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "finalize PMDNode");
        }
    }
}

