/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import javax.vecmath.Vector3f;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;

public class PMDSkinVertData
implements Serializable {
    private int skinVertIndex;
    private Vector3f skinVertPos;

    public String toString() {
        return "{skinVertIndex = " + this.skinVertIndex + " skinVertPos = " + this.skinVertPos;
    }

    public PMDSkinVertData(DataInputStreamLittleEndian is) throws IOException {
        this.skinVertIndex = is.readInt();
        this.skinVertPos = new Vector3f();
        this.skinVertPos.x = is.readFloat();
        this.skinVertPos.y = is.readFloat();
        this.skinVertPos.z = -is.readFloat();
    }

    public void writeToStream(DataOutput os) throws IOException {
        os.writeInt(this.skinVertIndex);
        os.writeFloat(this.skinVertPos.x);
        os.writeFloat(this.skinVertPos.y);
        os.writeFloat(-this.skinVertPos.z);
    }

    public int getSkinVertIndex() {
        return this.skinVertIndex;
    }

    public void setSkinVertIndex(int skinVertIndex) {
        this.skinVertIndex = skinVertIndex;
    }

    public Vector3f getSkinVertPos() {
        return this.skinVertPos;
    }

    public void setSkinVertPos(Vector3f skinVertPos) {
        this.skinVertPos = skinVertPos;
    }
}

