/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractLongBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBufferME_CDC_FP;
import com.jogamp.common.nio.PointerBufferSE;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;

public abstract class PointerBuffer
extends AbstractLongBuffer {
    protected HashMap dataMap = new HashMap();

    protected PointerBuffer(ByteBuffer bb) {
        super(bb, PointerBuffer.elementSize());
    }

    public static PointerBuffer allocate(int size) {
        if (Platform.isJavaSE()) {
            return new PointerBufferSE(ByteBuffer.wrap(new byte[PointerBuffer.elementSize() * size]));
        }
        return new PointerBufferME_CDC_FP(ByteBuffer.wrap(new byte[PointerBuffer.elementSize() * size]));
    }

    public static PointerBuffer allocateDirect(int size) {
        if (Platform.isJavaSE()) {
            return new PointerBufferSE(Buffers.newDirectByteBuffer(PointerBuffer.elementSize() * size));
        }
        return new PointerBufferME_CDC_FP(Buffers.newDirectByteBuffer(PointerBuffer.elementSize() * size));
    }

    public static PointerBuffer wrap(ByteBuffer src) {
        PointerBuffer res = Platform.isJavaSE() ? new PointerBufferSE(src) : new PointerBufferME_CDC_FP(src);
        res.updateBackup();
        return res;
    }

    public static int elementSize() {
        return Platform.is32Bit() ? 4 : 8;
    }

    public final PointerBuffer put(PointerBuffer src) {
        if (this.remaining() < src.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        while (src.hasRemaining()) {
            long addr = src.get();
            this.put(addr);
            Long addrL = new Long(addr);
            Buffer bb = (Buffer)this.dataMap.get(addrL);
            if (null != bb) {
                this.dataMap.put(addrL, bb);
                continue;
            }
            this.dataMap.remove(addrL);
        }
        return this;
    }

    public final PointerBuffer referenceBuffer(int index, Buffer bb) {
        if (null == bb) {
            throw new RuntimeException("Buffer is null");
        }
        if (!Buffers.isDirect(bb)) {
            throw new RuntimeException("Buffer is not direct");
        }
        long mask = Platform.is32Bit() ? 0xFFFFFFFFL : -1L;
        long bbAddr = this.getDirectBufferAddressImpl(bb) & mask;
        if (0L == bbAddr) {
            throw new RuntimeException("Couldn't determine native address of given Buffer: " + bb);
        }
        this.put(index, bbAddr);
        this.dataMap.put(new Long(bbAddr), bb);
        return this;
    }

    public final PointerBuffer referenceBuffer(Buffer bb) {
        this.referenceBuffer(this.position, bb);
        ++this.position;
        return this;
    }

    public final Buffer getReferencedBuffer(int index) {
        long addr = this.get(index);
        return (Buffer)this.dataMap.get(new Long(addr));
    }

    public final Buffer getReferencedBuffer() {
        Buffer bb = this.getReferencedBuffer(this.position);
        ++this.position;
        return bb;
    }

    private native long getDirectBufferAddressImpl(Object var1);

    @Override
    public String toString() {
        return "PointerBuffer:" + super.toString();
    }

    static {
        NativeLibrary.ensureNativeLibLoaded();
    }
}

